@php
use Illuminate\Support\Facades\Log;

$settings_data = \App\Models\Utility::settingsById($proposal->created_by);
Log::info('Settings Data Retrieved:', ['settings_data' => $settings_data]);

$addressParts = array_filter([
    $settings_data['company_city'] ?? '',
    $settings_data['company_state'] ?? '',
    $settings_data['company_zipcode'] ?? '',
]);
Log::info('Address Parts Generated:', ['addressParts' => $addressParts]);

$logo = \App\Models\Utility::get_file('uploads/logo');
$company_logo = \App\Models\Utility::GetLogo();
$companyState = strtolower(trim($settings_data['company_state'] ?? ''));
$billingState = strtolower(trim($customer->billing_state ?? ''));
$isSameState = !empty($companyState) && !empty($billingState) && $companyState === $billingState;
@endphp

@php
    $proposal_logo = \App\Models\Utility::getValByName('proposal_logo');
    $img = \App\Models\Utility::get_file('proposal_logo/') . $proposal_logo;
   
@endphp

<!DOCTYPE html>
<html lang="en" dir="{{ $settings_data['SITE_RTL'] == 'on' ? 'rtl' : '' }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
      <link
        href="https://fonts.googleapis.com/css2?family=Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900&display=swap"
        rel="stylesheet">
    <style>
        :root {
            --theme-color: {{ $color }};
            --white: #ffffff;
            --black: #000000;
        }
        p { margin: 3px !important; }
        body {
            font-family: 'Lato', sans-serif;
            margin: 0;
            padding:0;
            background: #f8f9fa;
        }
        .proposal-container {
            max-width: 800px;
            margin: 0 auto;
            background: #fff;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            border: 1px solid black;
            
            
        }
        .proposal-header h3 {
            border-top: 5px solid var(--theme-color);
            padding-top: 10px;
            text-transform: uppercase;
            font-size: 32px;
            font-weight: bold;
            margin-bottom: 0;
        }
        .company-info, .proposal-info {
            font-size: 14px;
        }
        .company-logo {
            max-width: 180px;
        }
        .info-table {
            width: 100%;
            margin-top: 20px;
        }
        .info-table td {
            vertical-align: top;
            padding: 10px 0;
        }
        .text-right { text-align: right; }
        .text-left { text-align: left; }
        .qrcode {
            max-width: 150px;
        }
        .dataTable th, .dataTable td {
            border-left: 1px solid black;
            border-right: 1px solid black;
        }
        .dataTable th {
            padding: 5px;
            border-top: 1px solid black;
            border-bottom: 1px solid black;
        }
        .amtTable td, .amtTable th {
            border-collapse: collapse;
            border-right: 1px solid black;
            border-bottom: 1px solid black;
        }
        .amtTable th {
            font-weight: normal;
        }
         html[dir="rtl"] table tr td,
        html[dir="rtl"] table tr th {
            text-align: right;
        }

        html[dir="rtl"] .text-right {
            text-align: left;
        }

        html[dir="rtl"] .view-qrcode {
            margin-left: 0;
            margin-right: auto;
        }
        table.add-border {
            border: 1px solid var(--theme-color);
        }
        .proposal-footer {
            padding: 15px 20px;
        }
    </style>
     @if ($settings_data['SITE_RTL'] == 'on')
        <link rel="stylesheet" href="{{ asset('css/bootstrap-rtl.css') }}">
    @endif
</head>
<body>
    <div >
<div class="proposal-container" id="boxes">
    <div class="proposal-header" style="background: {{$color}};color:{{$fontColor}}">
        <div style="border-bottom: 1px solid black; text-align: center; padding:10px;">Proposal</div>
        <div style="display: flex; justify-content: space-between; align-items: center; border-bottom: 1px solid black; padding: 10px 10px;">
            <div>
                <img src="{{ $img . '?t=' . time() }}" alt="Logo">
            </div>
            <div style="text-align: center;">
                <p style="text-transform: uppercase; font-size: 20px; font-weight: bold; color: #003580;">{{ $settings['company_name'] ?? '' }}</p>
                <p style="text-transform: uppercase; font-size: 15px; font-weight: bold;">{{ $settings_data['company_address'] ?? '' }}</p>
                <p style="text-transform: uppercase; font-size: 15px; font-weight: bold;">{{ implode(' , ', $addressParts) ?: '' }}</p>
                <p style="font-weight: bold;">{{ __('Tel:') }} {{ $settings['company_telephone'] ?? '' }}, {{ __('E-Mail:') }} {{ $settings['mail_from_address'] ?? '' }}</p>
                @if($settings['vat_gst_number_switch'] == 'on')
                    @if(!empty($settings['tax_type']) && !empty($settings['vat_number']))
                    <p style="font-weight: bold; text-align: center;">{{$settings['tax_type'].' '. __('Number')}} : {{$settings['vat_number']}} </p>
                        @endif
                       @endif
            </div>
            <div style="border: 1px solid black; padding: 3px;">
                @if ($settings['qr_display'] == 'on')
                    <div class="qrcode">
                        {!! DNS2D::getBarcodeHTML(route('proposal.link.copy', Crypt::encrypt($proposal->id)), 'QRCODE', 2, 2) !!}
                    </div>
                @endif
            </div>
        </div>
    </div>
    <div class="proposal-body">
        <div style="border-bottom: 1px solid black; padding: 0 10px">
            <table>
                <tr><td>{{ __('IRN') }}</td><td>:</td><td><strong>{{ $proposal->irn ?? '' }}</strong></td></tr>
                <tr>
                    <td>{{ __('Ack No') }}</td><td>:</td><td><strong>{{ \App\Models\Utility::proposalNumberFormat($settings,$proposal->proposal_id) }}</strong></td>
                    <td style="padding-left: 80px;">{{ __('Ack Date') }}</td><td>:</td><td><strong>{{ \App\Models\Utility::dateFormat($settings, $proposal->issue_date) }}</strong></td>
                    @php
    use Carbon\Carbon;

    $issueDate = Carbon::parse($proposal->issue_date);
    $validityDate = $issueDate->copy()->addDays(15);
@endphp

<td style="padding-left: 80px;">{{ __('Valid To') }}</td>
<td>:</td>
<td><strong>{{ \App\Models\Utility::dateFormat($settings, $validityDate) }}</strong></td>
                </tr>
            </table>
        </div>
    </div>
    <div style="border-bottom: 1px solid black; display: flex; justify-content: space-between; background-color: #e4e6fc; padding: 0 10px; font-weight: bold;">
        <p>{{ __('GSTIN/UIN:') }} {{ $customer->tax_number ?? '' }}</p>
        <p>{{ __('PAN NO:') }} {{ $settings_data['pan_number'] ?? '' }}</p>
    </div>
    <div style="padding: 0 10px; display: flex; border-bottom: 1px solid black;">
        <div style="border-right: 1px solid black; flex: 1; box-sizing: border-box;">
            <strong style="margin-bottom: 10px;">{{ __('Buyer(Bill To)') }}</strong>
            @if (!empty($customer->billing_name))
                <p>
                    <span style="color: #003580; font-weight: bold;">{{ $customer->billing_name }}</span><br>
                    {{ $customer->billing_address ?? '' }}<br>
                    {{ $customer->billing_city ?? '' }},<br>
                    {{ __('State Name :') }} {{ $customer->billing_state ?? '' }}- {{ $customer->billing_zip ?? '' }}<br>
                 
                    {{ __('GSTIN NO:') }} {{ $customer->tax_number ?? '' }}
                </p>
            @else
                <p>-</p>
            @endif
        </div>
        @if ($settings['shipping_display'] == 'on')
            <div style="border-right: 1px solid black; flex: 1; box-sizing: border-box; padding: 0 10px;">
                <strong style="margin-bottom: 10px;">{{ __('Consignee(Ship To)') }}</strong>
                @if (!empty($customer->shipping_name))
                    <p>
                        <span style="color: #003580; font-weight: bold;">{{ $customer->shipping_name }}</span><br>
                        {{ $customer->shipping_address ?? '' }}<br>
                        {{ $customer->shipping_city ?? '' }},<br>
                        {{ __('State Name :') }} {{ $customer->shipping_state ?? '' }}- {{ $customer->billing_zip ?? '' }}<br>
                       
                        {{ __('GSTIN NO:') }} {{ $customer->tax_number ?? '' }}
                    </p>
                @else
                    <p>-</p>
                @endif
            </div>
        @endif
        <div style="flex: 1; box-sizing: border-box; padding: 0 10px;">
            <table>
                <tr><td>Proposal No</td><td>:</td><td>{{ \App\Models\Utility::proposalNumberFormat($settings,$proposal->proposal_id) }}</td></tr>
                <tr><td>Date</td><td>:</td><td>{{ \App\Models\Utility::dateFormat($settings, $proposal->send_date ?? $proposal->issue_date) }}</td></tr>
                <tr><td>E-way Bill No</td><td>:</td><td>{{ $proposal->eway_bill_no ?? '' }}</td></tr>
                <tr><td>Delivery Distance</td><td>:</td><td>{{ $proposal->delivery_note_no ?? '' }}</td></tr>
                <tr><td>Buyer Order No</td><td>:</td><td>{{ $proposal->buyer_order_no ?? '' }}</td></tr>
            </table>
        </div>
    </div>

    <table style="width: 100%; border-collapse: collapse;" class="dataTable add-border">
      <thead style="background: {{ $color }};color:{{ $fontColor }}">
            <tr>
                <th>{{ __('S.No') }}</th>
                <th style="width: 100% !important;">{{ __('Description') }}</th>
                <th style="width: 50%;">{{ __('HSN/SAC Code') }}</th>
                <th style="width: 50%;">{{ __('Qty') }}</th>
                <th style="width: 50%;">{{ __('Unit') }}</th>
                <th style="width: 50%;">{{ __('(Incl)Rate') }}</th>
                <th style="width: 50%;">{{ __('Rate') }}</th>
                <th style="width: 50%;">{{ __('Disc') }}</th>
                <th style="width: 50%;">{{ __('Amount') }}</th>
            </tr>
        </thead>
        <tbody>
        @php
    $totalAmount = 0;
    $grandTotal = 0;
    $totalCgst = 0;
    $totalSgst = 0;
    $totalIgst = 0;
    $totalVat = 0;
@endphp

@if (isset($proposal->itemData) && count($proposal->itemData) > 0)
    @foreach ($proposal->itemData as $item)
        @php
            // Subtotal before tax
            $itemTotal = ($item->price ?? 0) * ($item->quantity ?? 0) - ($item->discount ?? 0);
            $totalAmount += $itemTotal;

            $itemTaxPrice = 0;

            if (!empty($item->itemTax) && is_array($item->itemTax)) {
                foreach ($item->itemTax as $tax) {
                    $taxPrice = floatval($tax['tax_price'] ?? 0);
                    $itemTaxPrice += $taxPrice;

                    if (strtolower($tax['name']) === 'cgst') {
                        $totalCgst += $taxPrice;
                    } elseif (strtolower($tax['name']) === 'sgst') {
                        $totalSgst += $taxPrice;
                    } elseif (strtolower($tax['name']) === 'igst') {
                        $totalIgst += $taxPrice;
                    } elseif (strtolower($tax['name']) === 'vat') {
                        $totalVat += $taxPrice;
                    }
                }
            }

            // Add item total (with tax) to grand total
            $grandTotal += $itemTotal + $itemTaxPrice;

            // Convert grand total to words
            $formatter = new \NumberFormatter('en_IN', \NumberFormatter::SPELLOUT);
            $grandTotalWords = ucfirst($formatter->format(floor($grandTotal))) . ' rupees';
            $decimalPart = round(($grandTotal - floor($grandTotal)) * 100);
            if ($decimalPart > 0) {
                $grandTotalWords .= ' and ' . $formatter->format($decimalPart) . ' paise';
            }
            $grandTotalWords .= ' only';

            $unitDisplay = optional(\App\Models\ProductServiceUnit::find($item->unit))->name ?? '';
            Log::info('Item Data in Template:', [
                'item' => $item,
                'unitDisplay' => $unitDisplay,
                'itemTotal' => $itemTotal,
                'itemTax' => $item->itemTax
            ]);
        @endphp
    

                    <tr>
                        <td  style="text-align:center;">{{ $loop->iteration }}</td>
                        <td  style="text-align:center;">{{ $item->name ?? '' }}</td>
                        <td style="text-align:center;">{{ $item->expense_chartaccount_code ??'-' }}</td>
                        <td  style="font-weight: bold; text-align:center;">{{ $item->quantity ?? 0 }}</td>
                        <td style="text-align:center;">{{ $unitDisplay }}</td>
                        <td style="text-align:center;">{{ number_format($item->price ?? 0, 2) }}</td>
                        <td style="text-align:center;">{{ number_format($item->price ?? 0, 2) }}</td>
                        <td style="text-align:center;">{{ $item->discount != 0 ? number_format($item->discount ?? 0, 2) : '-' }}</td>
                        <td  style="font-weight: bold; text-align:center;">{{ number_format($itemTotal, 2) }}</td>
                    </tr>
                @endforeach
            @else
                <tr><td colspan="10" class="text-center">No items found</td></tr>
            @endif
        </tbody>
        <tfoot style="border-top: 1px solid black; border-bottom: 1px solid black;">
            <tr>
                <td></td>
                <td style="text-align: center"><strong>{{ __('TOTAL') }}</strong></td>
                <td></td><td></td><td></td><td></td><td></td><td></td>
                <td class="text-right" style="font-weight: bold;">{{ number_format($totalAmount, 2) }}</td>
            </tr>
        </tfoot>
    </table>

    <div style="display: flex; justify-content: space-between; border-bottom: 1px solid black;">
        <div style="border-right: 1px solid black; width: 50%;">
            <div style="display: flex; width: 100%;   border-bottom: 1px solid black;">
                <div style="width: 35%;padding: 10px; font-weight: normal;">Amount In Words:</div>
                <div style="width: 65%; padding-bottom: 23px;">
                    <strong>{{ $grandTotalWords }}</strong>
                </div>
            </div>
            <div style="display: flex; padding: 10px; width: 100%;">
                <!-- <div style="width: 30%;">
                    @if ($settings['qr_display'] == 'on')
                        <div class="qrcode">
                            {!! DNS2D::getBarcodeHTML(route('proposal.link.copy', Crypt::encrypt($proposal->id)), 'QRCODE', 2, 2) !!}
                        </div>
                    @endif
                </div> -->
                <div style="width: 70%;">
                    <table>  
                        @if ($accounts->isNotEmpty())
    @php $account = $accounts->first(); @endphp
    <tr><td>Bank Name</td><td>:</td><td>{{ $account->bank_name ?? '' }}</td></tr>
    <tr><td>Ac/No</td><td>:</td><td>{{ $account->holder_name ?? '' }}</td></tr>
    <tr><td>Branch & IFS Code</td><td>:</td><td>{{ $account->branch_name ?? '' }} {{ $account->ifs_code ?? '' }}</td></tr>
@else
    <tr><td colspan="3">No bank details available.</td></tr>
@endif
                    </table>
                </div>
            </div>
        </div>
        <div style="width: 50%;">
            <table class="amtTable">
                <tbody>
                    <tr><td style="width: 25%; font-weight: bold;">Basic Amount</td><td style="width: 25%; font-weight: bold;" class="text-right">{{ number_format($totalAmount, 2) }}</td></tr>
                
                </tbody>
            </table>
        </div>
    </div>

    @php
    $cgstRate = 0;
    $sgstRate = 0;
    $igstRate = 0;
    $totalTax = 0;

    if (isset($proposal->itemData) && count($proposal->itemData) > 0) {
        foreach ($proposal->itemData as $item) {
            if (!empty($item->itemTax) && is_array($item->itemTax)) {
                foreach ($item->itemTax as $tax) {
                    if (is_array($tax)) {
                        $rate = floatval(str_replace('%', '', $tax['rate'] ?? '0'));
                        $amount = floatval($tax['tax_price'] ?? 0);
                        if ($isSameState && ($tax['name'] === 'CGST' || $tax['name'] === 'SGST')) {
                            if ($tax['name'] === 'CGST') $cgstRate = $rate;
                            if ($tax['name'] === 'SGST') $sgstRate = $rate;
                        } elseif (!$isSameState && $tax['name'] === 'IGST') {
                            $igstRate = $rate+$rate;
                        }
                        $totalTax += $amount;
                    }
                }
            }
        }
    }
    
    @endphp

    <!-- <table style="width: 100%;" class="amtTable">
        <thead>
            <tr>
                <th rowspan="2" style="width: 470px;" class="text-right">Taxable Value</th>
                @if ($isSameState && ($totalCgst > 0 || $totalSgst > 0))
                    <th colspan="2">CGST</th>
                    <th colspan="2">SGST/UTGST</th>
                @elseif ($totalIgst > 0)
                    <th colspan="2">IGST</th>
                @endif
                <th rowspan="2" style="width: 100px;">Total <br>Tax Amount</th>
            </tr>
            <tr>
                @if ($isSameState && ($totalCgst > 0 || $totalSgst > 0))
                    <th>Rate</th>
                    <th>Amount</th>
                    <th>Rate</th>
                    <th>Amount</th>
                @elseif ($totalIgst > 0)
                    <th>Rate</th>
                    <th>Amount</th>
                @endif
            </tr>
        </thead>
        <tbody>
            <tr>
                <td class="text-right">{{ number_format($totalAmount ?? 0, 2) }}</td>
                @if ($isSameState && ($totalCgst > 0 || $totalSgst > 0))
                    <td style="text-align: center">{{ number_format($cgstRate, 2) }}%</td>
                    <td class="text-right">{{ number_format($totalCgst, 2) }}</td>
                    <td style="text-align: center">{{ number_format($sgstRate, 2) }}%</td>
                    <td class="text-right">{{ number_format($totalSgst, 2) }}</td>
                @elseif ($totalIgst > 0)
                    <td style="text-align: center">{{ number_format($igstRate, 2) }}%</td>
                    <td class="text-right">{{ number_format($totalIgst, 2) }}</td>
                @endif
                <td class="text-right">{{ number_format($totalTax, 2) }}</td>
            </tr>
        </tbody>
        <tfoot style="border-bottom: 1px solid black;">
            <tr>
                <td class="text-right" style="font-weight: bold;">Total: {{ number_format($totalAmount ?? 0, 2) }}</td>
                @if ($isSameState && ($totalCgst > 0 || $totalSgst > 0))
                    <td></td>
                    <td class="text-right" style="font-weight: bold;">{{ number_format($totalCgst, 2) }}</td>
                    <td></td>
                    <td class="text-right" style="font-weight: bold;">{{ number_format($totalSgst, 2) }}</td>
                @elseif ($totalIgst > 0)
                    <td></td>
                    <td class="text-right" style="font-weight: bold;">{{ number_format($totalIgst, 2) }}</td>
                @endif
                <td class="text-right" style="font-weight: bold;">{{ number_format($totalTax, 2) }}</td>
            </tr>
        </tfoot>
    </table> -->

    <div style="display: flex; justify-content: space-between; border-bottom: 1px solid black;">
        <div style="border-right: 1px solid black; width: 50%; padding: 10px;">
            <p><strong>Terms & Condition:</strong></p>
            <ul>
                <li>Goods once sold will not be taken back.</li>
                <li>
                   Interest @10%
            <!-- @if ($isSameState)
                {{ number_format($cgstRate + $sgstRate, 2) }}%
            @elseif ($totalIgst > 0)
                {{ number_format($igstRate, 2) }}%
            @else
                0%
            @endif -->
            p.a. will be charged if the payment is not made within the stipulated time.
                </li>
                <li>We declare that this invoice shows the actual price of the goods described and that all particulars are true and correct.</li>
            </ul>
        </div>
        <div style="width: 50%; display: flex; flex-direction: column; align-items: flex-end; padding: 0 10px;">
            <p style="font-weight: bold;">For {{ $settings['company_name'] ?? '' }}</p>
           
            <p style="font-weight: bold; padding-top:130px;">Authorized Signatory</p>
        </div>
    </div>
</div>
<div style="text-align: center">
    <p>SUBJECT TO {{ strtoupper($settings['company_state'] ?? 'YOUR STATE') }} JURISDICTION</p>
    <p>This is a Computer Generated Invoice</p>
</div>
   <div class="proposal-footer" style="text-align: center">
            <b>{{$settings['footer_title']}}</b> <br>
            {!! $settings['footer_notes'] !!}
    </div>
</div>
  @if (!isset($preview))
        @include('proposal.script');
    @endif


</body>
</html>