@php
$logo = \App\Models\Utility::get_file('uploads/logo');
$company_logo = \App\Models\Utility::GetLogo();
$creatorId = \Auth::user()->creatorId();
$setting = DB::table('settings')->where('created_by', $creatorId)->pluck('value', 'name')->toArray();
$settings_data = \App\Models\Utility::settingsById($creatorId);
$settings_data = isset($proposal) ? \App\Models\Utility::settingsById($proposal->created_by) : \App\Models\Utility::settingsById($creatorId);
$company_state = strtolower(trim($settings_data['company_state'] ?? 'defaultstate'));
$vat = isset($settings_data['tax_type']) ? strtolower(trim($settings_data['tax_type'])) : 'vat';

@endphp

@extends('layouts.admin')

@section('page-title')
    {{__('Proposal Edit')}}
@endsection

@push('script-page')
    <script src="{{asset('js/jquery-ui.min.js')}}"></script>
    <script src="{{asset('js/jquery.repeater.min.js')}}"></script>
   
 <script>
$(document).ready(function () {
   const taxType = $('#tax_type').val()?.toLowerCase() || 'gst';

    const companyState = $('#company_state').val()?.toLowerCase().trim() || '';

    console.log('Proposal Tax Type:', taxType, 'Company State:', companyState);

    const selector = "body";

    if ($(selector + " .repeater").length) {
        const $dragAndDrop = $("body .repeater tbody").sortable({
            handle: '.sort-handler'
        });

        const $repeater = $(selector + ' .repeater').repeater({
            initEmpty: true,
            defaultValues: { 'status': 1 },
            show: function () {
                $(this).slideDown();
                updateItemOptions();
                setDefaultTax($(this));
            },
            hide: function (deleteElement) {
                if (confirm('Are you sure you want to delete this element?')) {
                    const el = $(this);
                    const id = el.find('.id').val();
                    if (id) {
                        $.ajax({
                            url: '{{ route("proposal.product.destroy") }}',
                            type: 'POST',
                            headers: { 'X-CSRF-TOKEN': $('#token').val() },
                            data: { id },
                            success: function (data) {
                                updateItemOptions();
                                show_toastr(data.status ? 'success' : 'error', data.message);
                            }
                        });
                    }
                    el.slideUp(deleteElement, function () {
                        el.remove();
                        calculateTotals();
                    });
                }
            },
            ready: function (setIndexes) {
                $dragAndDrop.on('drop', setIndexes);
            },
            isFirstItemUndeletable: true
        });

        const value = $(selector + " .repeater").attr('data-value');
        if (value && value.length) {
            const parsedValue = JSON.parse(value);
            $repeater.setList(parsedValue);
            parsedValue.forEach(row => {
                const tr = $('#sortable-table .id[value="' + row.id + '"]').closest('tr');
                tr.find('.item').val(row.product_id);
                changeItem(tr.find('.item'));
            });
        }
    }

    $(document).on('change', '#customer', function () {
        const customerId = $(this).val();
        const url = $(this).data('url');

        if (!customerId) {
            resetCustomerDisplay();
            return;
        }

        $.ajax({
            url,
            type: 'POST',
            headers: { 'X-CSRF-TOKEN': $('#token').val() },
            data: { id: customerId },
            success: function (response) {
                if (response.error) {
                    resetCustomerDisplay();
                    return;
                }
                const billingState = response.state || '';
                $('input[name="billing_state"]').val(billingState.toLowerCase().trim());
                $('#customer_detail').html(response.view).removeClass('d-none').addClass('d-block');
                $('#customer-box').removeClass('d-block').addClass('d-none');
                updateTaxDisplay();
            },
            error: function () {
                resetCustomerDisplay();
            }
        });
    });

    function resetCustomerDisplay() {
        $('#customer-box').removeClass('d-none').addClass('d-block');
        $('#customer_detail').removeClass('d-block').addClass('d-none').html('');
        $('input[name="billing_state"]').val('');
        updateTaxDisplay();
    }

    $(document).on('click', '#remove', resetCustomerDisplay);

    $(document).on('change', '.item', function () {
        changeItem($(this));
        updateItemOptions();
    });

    $(document).on('click', '[data-repeater-create]', updateItemOptions);

    $(document).on('keyup change', '.quantity, .price, .discount', function () {
        const el = $(this).closest('tr');
        calculateItemAmount(el);
        calculateTotals();
    });

    function updateItemOptions() {
        $('.item option').prop('hidden', false);
        $('.item :selected').each(function () {
            const id = $(this).val();
            if (id) $('.item').not(this).find("option[value=" + id + "]").prop('hidden', true);
        });
    }

    function setDefaultTax(el) {
        const defaultTaxRate = $('.itemTaxRate').first().val() || 0;
        const defaultTaxesHtml = $('.taxes').first().html() || '<span class="badge">No Tax Data</span>';
        el.find('.itemTaxRate').val(defaultTaxRate);
        el.find('.taxes').html(defaultTaxesHtml);
        calculateItemAmount(el);
    }

    function changeItem(element) {
        const productId = element.val();
        const url = element.data('url');
        const el = element.closest('tr');
        const proposalId = '{{ $proposal->id ?? 0 }}'; // fallback if $proposal is undefined

        $.ajax({
            url,
            type: 'POST',
            headers: { 'X-CSRF-TOKEN': $('#token').val() },
            data: { product_id: productId },
            success: function (data) {
                const item = JSON.parse(data);
                $.ajax({
                    url: '{{ route("proposal.items") }}',
                    type: 'GET',
                    headers: { 'X-CSRF-TOKEN': $('#token').val() },
                    data: { proposal_id: proposalId, product_id: productId },
                    success: function (data) {
                        const proposalItem = JSON.parse(data);
                        el.find('.quantity').val(proposalItem?.quantity || 1);
                        el.find('.price').val(proposalItem?.price || item.product.sale_price);
                        el.find('.discount').val(proposalItem?.discount || 0);
                        el.find('.pro_description').val(proposalItem?.description || item.product.description);

                        const taxRate = calculateTaxRate(item.taxes || []);
                        const billingState = $('input[name="billing_state"]').val().toLowerCase().trim();
                        const isSameState = companyState === billingState;

                        el.find('.taxes').html(buildTaxBadge(taxRate, isSameState));
                        el.find('.itemTaxRate').val(taxRate.toFixed(2));
                        el.find('.unit').html(item.unit || '');
                        calculateItemAmount(el);
                        calculateTotals();
                    }
                });
            }
        });
    }

   function calculateTaxRate(taxes) {
    let cgst = 0, sgst = 0, igst = 0, vat = 0;
    let hasVAT = false;

    taxes.forEach(tax => {
        const name = tax.name?.toUpperCase().trim();

        switch (name) {
            case 'VAT':
                vat = parseFloat(tax.rate) || 0;
                hasVAT = true;
                break;
            case 'CGST':
                cgst = parseFloat(tax.rate) || 0;
                break;
            case 'SGST':
                sgst = parseFloat(tax.rate) || 0;
                break;
            case 'IGST': 
                igst = parseFloat(tax.rate) || 0;
                break;
        }
    });

    return hasVAT ? vat : (cgst + sgst || igst || 0);
}


   function buildTaxBadge(rate, isSameState) {
    if (taxType === 'vat') {
        return `<span class="badge badge-success">VAT (${rate.toFixed(2)}%)</span>`;
    }
    if (rate === 0) return '<span class="badge">No Tax Data</span>';
    return isSameState
        ? `<span class="badge">CGST (${(rate / 2).toFixed(2)}%)</span><span class="badge">SGST (${(rate / 2).toFixed(2)}%)</span>`
        : `<span class="badge">IGST (${rate.toFixed(2)}%)</span>`;
}


    function calculateItemAmount(el) {
        const qty = parseFloat(el.find('.quantity').val()) || 0;
        const price = parseFloat(el.find('.price').val()) || 0;
        const discount = parseFloat(el.find('.discount').val()) || 0;
        const taxRate = parseFloat(el.find('.itemTaxRate').val()) || 0;
        const netPrice = qty * price - discount;
        const taxAmount = (taxRate / 100) * netPrice;
        el.find('.itemTaxPrice').val(taxAmount.toFixed(2));
        el.find('.amount').html((netPrice + taxAmount).toFixed(2));
    }

    function calculateTotals() {
        let subTotal = 0, totalTax = 0, totalDiscount = 0;
        $('.repeater tbody tr').each(function () {
            const qty = parseFloat($(this).find('.quantity').val()) || 0;
            const price = parseFloat($(this).find('.price').val()) || 0;
            const discount = parseFloat($(this).find('.discount').val()) || 0;
            const taxPrice = parseFloat($(this).find('.itemTaxPrice').val()) || 0;
            subTotal += qty * price;
            totalDiscount += discount;
            totalTax += taxPrice;
        });
        $('.subTotal').html(subTotal.toFixed(2));
        $('.totalDiscount').html(totalDiscount.toFixed(2));
        $('.totalTax').html(totalTax.toFixed(2));
        $('.totalAmount').html((subTotal - totalDiscount + totalTax).toFixed(2));
    }

    if ($('#customer').val()) {
        $('#customer').trigger('change');
    }
});
</script>



@endpush
@push('css-page')
    <style>
        .taxes {
            display: block !important;
            overflow: visible !important;
            min-height: 20px;
            margin-bottom: 5px;
        }
        .tax-display {
            display: flex !important;
            flex-wrap: wrap;
            gap: 8px;
            align-items: center;
        }
        .taxes .badge {
            display: inline-block !important;
            white-space: normal !important;
            background-color: white;
            color: black;
            padding: 5px 10px;
            font-size: 0.85rem;
            border-radius: 5px;
        }
        @media (max-width: 768px) {
            .taxes { min-height: auto; margin-bottom: 10px; }
            .tax-display { flex-direction: column; gap: 10px; }
        }
    </style>
@endpush
@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{route('dashboard')}}">{{__('Dashboard')}}</a></li>
    <li class="breadcrumb-item"><a href="{{route('proposal.index')}}">{{__('Proposal')}}</a></li>
    <li class="breadcrumb-item">{{__('Proposal Edit')}}</li>
@endsection

@section('content')
    <div class="row">
        {{ Form::model($proposal, ['route' => ['proposal.update', $proposal->id], 'method' => 'PUT', 'class' => 'w-100 needs-validation', 'novalidate']) }}
        <div class="col-12">
            <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">
            <input type="hidden" id="company_state" name="company_state" value="{{ $company_state }}">
            <input type="hidden" name="billing_state" value="{{ strtolower(trim($customer->billing_state ?? '')) }}">
            <input type="hidden" id="tax_type" value="{{ $tax_type }}">
           

   <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group" id="customer-box">
                                {{ Form::label('customer_id', __('Customer'), ['class' => 'form-label']) }}<x-required></x-required>
                                {{ Form::select('customer_id', $customers, null, ['class' => 'form-control select', 'id' => 'customer', 'data-url' => route('proposal.customer'), 'required' => 'required']) }}
                                <div class="text-xs mt-1">
                                    {{ __('Create customer here.') }} <a href="{{ route('customer.index') }}"><b>{{ __('Create customer') }}</b></a>
                                </div>
                            </div>
                            <div id="customer_detail" class="d-none"></div>
                        </div>
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        {{ Form::label('issue_date', __('Issue Date'), ['class' => 'form-label']) }}<x-required></x-required>
                                        {{ Form::date('issue_date', null, ['class' => 'form-control', 'required' => 'required']) }}
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    {{ Form::label('category_id', __('Category'), ['class' => 'form-label']) }}<x-required></x-required>
                                    {{ Form::select('category_id', $category, null, ['class' => 'form-control select', 'required' => 'required']) }}
                                    <div class="text-xs mt-1">
                                        {{ __('Create category here.') }} <a href="{{ route('product-category.index') }}"><b>{{ __('Create category') }}</b></a>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group mb-0">
                                        {{ Form::label('proposal_number', __('Proposal Number'), ['class' => 'form-label']) }}
                                        <input type="text" class="form-control" value="{{ $proposal_number }}" readonly>
                                    </div>
                                </div>
                                @if(!$customFields->isEmpty())
                                    @include('customFields.formBuilder')
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12">
            <h5 class="d-inline-block mb-4">{{__('Product & Services')}}</h5>
            <div class="card repeater" data-value='{{ json_encode($proposal->items) }}'>
                <div class="item-section">
                    <div class="card-header border-0 pb-0 d-flex justify-content-end">
                        <div class="all-button-box">
                            <a href="#" data-repeater-create class="btn btn-primary d-flex align-items-center gap-1 justify-content-center">
                                <i class="ti ti-plus"></i> {{__('Add Item')}}
                            </a>
                        </div>
                    </div>
                </div>
                <div class="card-body mt-2">
                    <div class="table-responsive">
                        <table class="table mb-0" data-repeater-list="items" id="sortable-table">
                            <thead>
                                <tr>
                                    <th>{{__('Items')}}<x-required></x-required></th>
                                    <th>{{__('Quantity')}}<x-required></x-required></th>
                                    <th>{{__('Price')}}<x-required></x-required></th>
                                    <th>{{__('Discount')}}<x-required></x-required></th>
                                    <th>{{__('Tax')}} (%)</th>
                                    <th class="text-end">{{__('Amount')}} <br><small class="text-danger font-weight-bold">{{__('after tax & discount')}}</small></th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody class="ui-sortable" data-repeater-item>
                                <tr>
                                    {{ Form::hidden('id', null, ['class' => 'form-control id']) }}
                                    <td width="25%" class="form-group pt-0">
                                        {{ Form::select('item', $product_services, null, ['class' => 'form-control select item', 'data-url' => route('proposal.product')]) }}
                                    </td>
                                    <td>
                                        <div class="form-group price-input input-group search-form">
                                            {{ Form::number('quantity', null, ['class' => 'form-control quantity', 'required' => 'required', 'placeholder' => __('Qty')]) }}
                                            <span class="unit input-group-text bg-transparent"></span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="form-group price-input input-group search-form">
                                            {{ Form::number('price', null, ['class' => 'form-control price', 'required' => 'required', 'placeholder' => __('Price')]) }}
                                            <span class="input-group-text bg-transparent">{{\Auth::user()->currencySymbol()}}</span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="form-group price-input input-group search-form">
                                            {{ Form::number('discount', null, ['class' => 'form-control discount', 'required' => 'required', 'placeholder' => __('Discount')]) }}
                                            <span class="input-group-text bg-transparent">{{\Auth::user()->currencySymbol()}}</span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="form-group">
                                            <div class="taxes"></div>
                                            {{ Form::hidden('tax', '', ['class' => 'form-control tax']) }}
                                            {{ Form::hidden('itemTaxPrice', '', ['class' => 'form-control itemTaxPrice']) }}
                                            {{ Form::hidden('itemTaxRate', '', ['class' => 'form-control itemTaxRate']) }}
                                        </div>
                                    </td>
                                    <td class="text-end amount">0.00</td>
                                    <td>
                                        @can('delete proposal product')
                                            <div class="action-btn me-2">
                                                <a href="#" class="ti ti-trash text-white btn btn-sm repeater-action-btn bg-danger ms-2" data-bs-toggle="tooltip" title="{{ __('Delete') }}" data-repeater-delete></a>
                                            </div>
                                        @endcan
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2">
                                        <div class="form-group">
                                            {{ Form::textarea('description', null, ['class' => 'form-control pro_description', 'rows' => '2', 'placeholder' => __('Description')]) }}
                                        </div>
                                    </td>
                                    <td colspan="5"></td>
                                </tr>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td> </td>
                                    <td> </td>
                                    <td> </td>
                                    <td></td>
                                    <td><strong>{{__('Sub Total')}} ({{\Auth::user()->currencySymbol()}})</strong></td>
                                    <td class="text-end subTotal">0.00</td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td> </td>
                                    <td> </td>
                                    <td> </td>
                                    <td></td>
                                    <td><strong>{{__('Discount')}} ({{\Auth::user()->currencySymbol()}})</strong></td>
                                    <td class="text-end totalDiscount">0.00</td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td> </td>
                                    <td> </td>
                                    <td> </td>
                                    <td></td>
                                    <td><strong>{{__('Tax')}} ({{\Auth::user()->currencySymbol()}})</strong></td>
                                    <td class="text-end totalTax">0.00</td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td> </td>
                                    <td> </td>
                                    <td> </td>
                                    <td> </td>
                                    <td class="blue-text border-none"><strong>{{__('Total Amount')}} ({{\Auth::user()->currencySymbol()}})</strong></td>
                                    <td class="text-end totalAmount blue-text border-none">0.00</td>
                                    <td></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <input type="button" value="{{__('Cancel')}}" onclick="location.href = '{{route('proposal.index')}}';" class="btn btn-secondary me-2">
            <input type="submit" value="{{__('Update')}}" class="btn btn-primary">
        </div>
        {{ Form::close() }}
    </div>
@endsection