@php
$logo=\App\Models\Utility::get_file('uploads/logo');
 $company_logo=Utility::getValByName('company_logo');
@endphp
@php
$addressParts = array_filter([
    $settings_data['company_address'] ?? '',
    $settings_data['company_city'] ?? '',
    $settings_data['company_state'] ?? '',
    $settings_data['company_zipcode'] ?? '',
]);
@endphp
@php
    $salaryMonthParts = explode('-', $payslip->salary_month);
    $year = $salaryMonthParts[0];
    $month = $salaryMonthParts[1];

    // Optional: Convert month number to name
    $monthNames = [
        '01' => 'January', '02' => 'February', '03' => 'March',
        '04' => 'April', '05' => 'May', '06' => 'June',
        '07' => 'July', '08' => 'August', '09' => 'September',
        '10' => 'October', '11' => 'November', '12' => 'December'
    ];
    $monthName = $monthNames[$month];
@endphp

@extends('layouts.admin')
@section('page-title')
{{__('Payslip')}}
@endsection


@section('content')
<div class="main-content">
<div class="text-md-right mb-2">
<a href="#" class="btn btn-warning" onclick="saveAsPDF()"><span class="fa fa-download"></span></a>
</div>
<div class="col-8">
<div class="invoice " id="printableArea">
<div class="invoice-print">
<div class="row">
<div class="col-lg-12">
<div class="invoice-title">
<h4>{{__('Payslip')}}</h4>
<div class="invoice-number">
<!-- <img src="{{$logo.'/'.(isset($company_logo) && !empty($company_logo)?$company_logo:'logo-dark.png')}}" width="170px;" alt=""> -->
 <p class="text-center fw-bold text-uppercase">{{ $settings_data['company_name'] ?? 'Company Name' }}</p>
 @if(empty($settings_data['company_name']))
        <p class="text-center text-danger text-uppercase fw-bold">Update company details from settings</p>
    @endif
<p class="text-center text-uppercase">{{ implode(' , ', $addressParts) }}</p>
</div>
</div>
<p class="text-center fw-bold">Payslip for the month of {{ $monthName }} {{ $year }}</p>
<div class="row">
<div class="col-md-6">
<address>
 <strong>{{__('Name')}} :</strong> {{$employee->name}}<br>
 <strong>{{ __('Join Date') }} :</strong> {{ \App\Models\Utility::formatDate($employee->company_doj) }}<br>
 <strong>{{__('Location')}} :</strong> {{$employee->branch_location}}<br>
 <strong>{{__('Effective Working Days')}} :</strong>{{$payslip->working_days}}<br>
 <strong>{{__('Days In Month')}} :</strong> {{$payslip->days_in_month}}<br>
<strong>{{__('Pan No')}}:</strong>{{$employee->pan_number}}
</address>
</div>
<div class="col-md-6 text-start">
<address>
 <strong>{{__('PF No')}} :</strong> {{$employee->pf_number}}<br>
 <strong>{{__('UAN No')}} :</strong> {{$employee->uan_number}}<br>
 <strong>{{__('ESI NO')}} :</strong> {{$employee->esi_number}}<br>
 <strong>{{__('Bank Details')}} :</strong>

{{ $employee->account_number }}<br>
{{ $employee->bank_identifier_code }}<br>
{{ $employee->bank_name }} <br>

</address>
</div>
</div>
</div>
</div>
<div class="row mt-2">
 <div class="col-md-12">
 <div class="card-body table-border-style">

@php
$allowances = json_decode($payslip->allowance ?? '[]');
$commissions = json_decode($payslip->commission ?? '[]');
$overtimes = json_decode($payslip->overtime ?? '[]');
$other_payments = json_decode($payslip->other_payment ?? '[]');
$deductions = json_decode($payslip->saturation_deduction ?? '[]');
$loans = json_decode($payslip->loan ?? '[]');

// Combine all earnings into one array
$all_earnings = [];
foreach ($allowances as $item) {
    $full = $item->type == 'percentage' ? ($item->amount * $payslip->basic_salary) / 100 : $item->amount;
    $actual = $item->type == 'percentage' ? ($item->actual_amount * $payslip->basic_salary) / 100 : $item->actual_amount;
    $all_earnings[] = ['title' => $item->title, 'full' => $full, 'actual' => $actual];
}
foreach ($commissions as $item) {
    $amount = $item->type == 'percentage' ? ($item->amount * $payslip->basic_salary) / 100 : $item->amount;
    $all_earnings[] = ['title' => $item->title, 'full' => $amount, 'actual' => $amount];
}
foreach ($other_payments as $item) {
    $amount = $item->type == 'percentage' ? ($item->amount * $payslip->basic_salary) / 100 : $item->amount;
    $all_earnings[] = ['title' => $item->title, 'full' => $amount, 'actual' => $amount];
}
foreach ($overtimes as $ot) {
    $amount = ($ot->number_of_days ?? 0) * ($ot->hours ?? 0) * ($ot->rate ?? 0);
    $all_earnings[] = ['title' => $ot->title, 'full' => $amount, 'actual' => $amount];
}

// Combine all deductions into one array (excluding LOP with 0 amount)
$all_deductions = [];
foreach ($deductions as $deduct) {
    $amount = $deduct->type == 'percentage' ? ($deduct->amount * $payslip->basic_salary) / 100 : $deduct->amount;
    if ($amount > 0) {
        $all_deductions[] = ['title' => $deduct->title, 'amount' => $amount];
    }
}
foreach ($loans as $loan) {
    $amount = $loan->amount ?? 0;
    if ($amount > 0) {
        $all_deductions[] = ['title' => $loan->title ?? 'Loan', 'amount' => $amount];
    }
}

$totalFullEarning = 0;
$totalActualEarning = 0;
$totalDeduction = 0;

// Calculate totals for earnings
foreach ($all_earnings as $earning) {
    $totalFullEarning += $earning['full'];
    $totalActualEarning += $earning['actual'];
}

// Calculate total deductions
foreach ($all_deductions as $deduction) {
    $totalDeduction += $deduction['amount'];
}

// Determine the maximum number of rows needed
$maxRows = max(count($all_earnings), count($all_deductions));
@endphp

<div class="table-responsive">
<table class="table table-bordered mt-4">
<thead class="text-center custom-header">
<tr>
<th>{{__('Earning')}}</th>
<th>{{__('Full')}}</th>
<th>{{__('Actual')}}</th>
<th>{{__('Deduction')}}</th>
<th>{{__('Actual')}}</th>
</tr>
</thead>
<tbody>
    @for ($i = 0; $i < $maxRows; $i++)
    <tr>
        {{-- Earnings Column --}}
        @if ($i < count($all_earnings))
            @php
            $earning = $all_earnings[$i];
            @endphp
            <td>{{ $earning['title'] }}</td>
            <td>{{ \Auth::user()->priceFormat($earning['full']) }}</td>
            <td>{{ \Auth::user()->priceFormat($earning['actual']) }}</td>
        @else
            <td></td><td></td><td></td>
        @endif

        {{-- Deductions Column --}}
        @if ($i < count($all_deductions))
            @php
            $deduction = $all_deductions[$i];
            @endphp
            <td>{{ $deduction['title'] }}</td>
            <td>{{ \Auth::user()->priceFormat($deduction['amount']) }}</td>
        @else
            <td></td><td></td>
        @endif
    </tr>
    @endfor

    <tr class="fw-bold">
    <td>{{ __('Total Earnings') }}</td>
    <td>{{ \Auth::user()->priceFormat($totalFullEarning) }}</td>
    <td>{{ \Auth::user()->priceFormat($totalActualEarning) }}</td>
    <td>{{ __('Total Deduction') }}</td>
    <td>{{ \Auth::user()->priceFormat($totalDeduction) }}</td>
    </tr>
</tbody>
</table>
</div>

@php
$netSalary = round($payslip->net_payble);
$netPay = max(0, round($payslip->net_payble)); 
$fmt = new \NumberFormatter('en_IN', \NumberFormatter::SPELLOUT);
$inWords = ucfirst($fmt->format($netPay)) . ' rupees only';
@endphp


<p class="mt-3">
<span class="fw-bold">{{ __('Net Pay for the Month (Total Earning - Total Deduction):') }}</span>
<span>{{ \Auth::user()->priceFormat($netSalary) }}</span><br>
<span>( {{ $inWords }} )</span>
</p>

<p class="text-center text-muted small fst-italic">
{{ __('THIS IS A SYSTEM GENERATED PAYSLIP AND DOES NOT REQUIRE SIGNATURE') }}</p>

</div>
</div>

</div>
</div>
</div>

@endsection
@push('script-page')
<script>

function saveAsPDF() {
var element = document.getElementById('printableArea');
var opt = {
margin: 0.3,
filename: '{{$employee->name}}',
image: {type: 'jpeg', quality: 1},
html2canvas: {scale: 4, dpi: 72, letterRendering: true},
jsPDF: {unit: 'in', format: 'A4'}
};
html2pdf().set(opt).from(element).save();
}

$(document).ready(function() {
saveAsPDF();
setTimeout(() => {
window.close();
}, 2000);
});
</script>
@endpush
