{{ Form::open(['url' => 'leave/changeaction', 'method' => 'post', 'class' => 'needs-validation', 'novalidate']) }}
    <div class="modal-body">
        <div class="row">
            <div class="col-12">
                <table class="table modal-table">
                    <tr>
                        <th>{{ __('Employee') }}</th>
                        <td>{{ $employee->name ?? '-' }}</td>
                    </tr>
                    <tr>
                        <th>{{ __('Leave Type') }}</th>
                        <td>{{ $leavetype->title ?? '-' }}</td>
                    </tr>
                    <tr>
                        <th>{{ __('Applied On') }}</th>
                        <td>{{ \Auth::user()->dateFormat($leave->applied_on) }}</td>
                    </tr>
                    <tr>
                        <th>{{ __('Start Date') }}</th>
                        <td>{{ \Auth::user()->dateFormat($leave->start_date) }}</td>
                    </tr>
                    <tr>
                        <th>{{ __('End Date') }}</th>
                        <td>{{ \Auth::user()->dateFormat($leave->end_date) }}</td>
                    </tr>
                    <tr>
                        <th>{{ __('Leave Reason') }}</th>
                        <td>{{ $leave->leave_reason ?? '-' }}</td>
                    </tr>
                    <tr>
                        <th>{{ __('Status') }}</th>
                        <td>
                            @switch($leave->status)
                                @case('Pending')
                                    <span class="badge bg-warning p-2 px-3 rounded">{{ $leave->status }}</span>
                                    @break
                                @case('tl_approved')
                                    <span class="badge bg-primary p-2 px-3 rounded">{{ __('TL Approved') }}</span>
                                    @break
                                @case('Approved')
                                    <span class="badge bg-success p-2 px-3 rounded">{{ $leave->status }}</span>
                                    @break
                                @case('Reject')
                                    <span class="badge bg-danger p-2 px-3 rounded">{{ __('Rejected') }}</span>
                                    @break
                                @default
                                    {{ $leave->status ?? '-' }}
                            @endswitch
                        </td>
                    </tr>
                </table>
            </div>
        </div>

        <input type="hidden" name="leave_id" value="{{ $leave->id }}">
    </div>

    <div class="modal-footer">
        <input type="hidden" name="status" id="status_input" value="">
       
        @if(\Auth::user()->type == 'Team Lead' && $leave->status == 'Pending')
            <button type="submit" class="btn btn-success" onclick="setStatus('tl_approved')">{{ __('Approve') }}</button>
            <button type="submit" class="btn btn-danger" onclick="setStatus('Reject')">{{ __('Reject') }}</button>
        @elseif(\Auth::user()->type == 'Reporting Manager' && $leave->status == 'tl_approved')
            <button type="submit" class="btn btn-success" onclick="setStatus('Approved')">{{ __('Approve') }}</button>
            <button type="submit" class="btn btn-danger" onclick="setStatus('Reject')">{{ __('Reject') }}</button>
        @endif
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
    </div>
{{ Form::close() }}
<script>
    function setStatus(status) {
        document.getElementById('status_input').value = status;
    }
</script>