
@php
$logo = \App\Models\Utility::get_file('uploads/logo');
$company_logo = \App\Models\Utility::GetLogo();
$creatorId = \Auth::user()->creatorId();
$setting = DB::table('settings')->where('created_by', $creatorId)->pluck('value', 'name')->toArray();
$settings_data = \App\Models\Utility::settingsById($creatorId);
$company_state = strtolower(trim($settings_data['company_state'] ?? 'defaultstate'));
$billing_state = $customer ? strtolower(trim($customer->billing_state ?? '')) : '';
@endphp

@extends('layouts.admin')

@section('page-title')
    {{__('Invoice Create')}}
@endsection

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{route('dashboard')}}">{{__('Dashboard')}}</a></li>
    <li class="breadcrumb-item"><a href="{{route('invoice.index')}}">{{__('Invoice')}}</a></li>
    <li class="breadcrumb-item">{{__('Invoice Create')}}</li>
@endsection

@push('script-page')
    <script src="{{asset('js/jquery-ui.min.js')}}"></script>
    <script src="{{asset('js/jquery.repeater.min.js')}}"></script>
    <script>
    var taxType = '{{ $tax_type ?? "gst" }}'; // Laravel injects tax_type from settings
    console.log('Tax Type from Settings:', taxType);

    var selector = "body";
    if ($(selector + " .repeater").length) {
        var $dragAndDrop = $("body .repeater tbody").sortable({
            handle: '.sort-handler'
        });
        var $repeater = $(selector + ' .repeater').repeater({
            initEmpty: false,
            defaultValues: { 'status': 1 },
            show: function () {
                $(this).slideDown();
                var $row = $(this).closest('tr');
                $row.find('.quantity').val(1);
                $row.find('.price').val(0);
                $row.find('.discount').val(0);
                var file_uploads = $(this).find('input.multi');
                if (file_uploads.length) {
                    file_uploads.MultiFile({
                        max: 3,
                        accept: 'png|jpg|jpeg',
                        max_size: 2048
                    });
                }
                updateTaxDisplay($row);
                preserveItemSelection();
            },
            hide: function (deleteElement) {
                if (confirm('Are you sure you want to delete this element?')) {
                    $(this).slideUp(deleteElement);
                    $(this).remove();
                    updateTotals();
                    preserveItemSelection();
                }
            },
            ready: function (setIndexes) {
                $dragAndDrop.on('drop', setIndexes);
            },
            isFirstItemUndeletable: true
        });
        var value = $(selector + " .repeater").attr('data-value');
        if (value) {
            $repeater.setList(JSON.parse(value));
        }
    }

    $(document).on('change', '#customer', function () {
        const id = $(this).val();
        const url = $(this).data('url');
        if (!id) {
            resetCustomerDisplay();
            return;
        }
        $.ajax({
            url: url,
            type: 'POST',
            headers: { 'X-CSRF-TOKEN': $('#token').val() },
            data: { id },
            success: function (response) {
                if (response.error) {
                    resetCustomerDisplay();
                    return;
                }
                $('input[name="billing_state"]').val((response.state || '').toLowerCase().trim());
                $('#customer_detail').html(response.view).removeClass('d-none').addClass('d-block');
                $('#customer-box').removeClass('d-block').addClass('d-none');
                updateTaxDisplay();
            },
            error: function () {
                resetCustomerDisplay();
            }
        });
    });

    function resetCustomerDisplay() {
        $('#customer-box').removeClass('d-none').addClass('d-block');
        $('#customer_detail').removeClass('d-block').addClass('d-none').html('');
        $('input[name="billing_state"]').val('');
        updateTaxDisplay();
    }

    $(document).on('click', '#remove', resetCustomerDisplay);

    $(document).on('change', '.item', function () {
        var itemId = $(this).val();
        var url = $(this).data('url');
        var $row = $(this).closest('tr');
        $.ajax({
            url: url,
            type: 'POST',
            headers: { 'X-CSRF-TOKEN': $('#token').val() },
            data: { 'product_id': itemId },
            cache: false,
            success: function (data) {
                var item = JSON.parse(data);
                $row.find('.quantity').val(1);
                $row.find('.price').val(item.product.sale_price || 0);
                $row.find('.pro_description').val(item.product.description || '');
                $row.find('.discount').val(0);
                $row.find('.unit').html(item.unit || '');

                var totalItemTaxRate = 0, cgstRate = 0, sgstRate = 0, igstRate = 0;
                if (item.taxes && Array.isArray(item.taxes)) {
                    item.taxes.forEach(tax => {
                        if (tax.name === 'CGST') cgstRate = parseFloat(tax.rate) || 0;
                        if (tax.name === 'SGST') sgstRate = parseFloat(tax.rate) || 0;
                        if (tax.name === 'IGST') igstRate = parseFloat(tax.rate) || 0;
                    });
                    totalItemTaxRate = (cgstRate + sgstRate > 0) ? (cgstRate + sgstRate) : igstRate;
                }

                $row.find('.itemTaxRate').val(totalItemTaxRate.toFixed(2));
                $row.find('.tax').val(item.taxes ? item.taxes.map(t => t.id).join(',') : '');
                updateTaxDisplay($row);
                calculateItemAmount($row);
                updateTotals();
                preserveItemSelection();
            },
            error: function (xhr) {
                console.error('Item AJAX Error:', xhr.responseText);
            }
        });
    });

    $(document).on('click', '[data-repeater-create]', preserveItemSelection);

    $(document).on('keyup change', '.quantity, .price, .discount', function () {
        var $row = $(this).closest('tr');
        calculateItemAmount($row);
        updateTaxDisplay($row);
        updateTotals();
    });

    function updateTaxDisplay($row = null) {
        const companyState = $('input[name="company_state"]').val().trim().toLowerCase();
        const billingState = $('input[name="billing_state"]').val().trim().toLowerCase();
        const isSameState = companyState === billingState;

        ($row || $('.repeater tbody tr')).each(function () {
            const $taxes = $(this).find('.taxes');
            const quantity = parseFloat($(this).find('.quantity').val()) || 0;
            const price = parseFloat($(this).find('.price').val()) || 0;
            const discount = parseFloat($(this).find('.discount').val()) || 0;
            const taxRate = parseFloat($(this).find('.itemTaxRate').val()) || 0;

            const totalPrice = quantity * price - discount;
            const { total, cgst, sgst, igst } = calculateTax(taxRate, totalPrice, isSameState);

            var taxHtml = '';
            if (taxType === 'vat') {
                taxHtml = `<span class="badge">VAT (${taxRate.toFixed(2)}%)</span>`;
            } else if (billingState && companyState) {
                if (isSameState && cgst && sgst) {
                    taxHtml = `<span class="badge">CGST (${(taxRate / 2).toFixed(2)}%)</span><span class="badge">SGST (${(taxRate / 2).toFixed(2)}%)</span>`;
                } else if (igst) {
                    taxHtml = `<span class="badge">IGST (${taxRate.toFixed(2)}%)</span>`;
                } else {
                    taxHtml = `<span class="badge">No Tax</span>`;
                }
            } else {
                taxHtml = `<span class="badge">No State Data</span>`;
            }

            $taxes.html(taxHtml);
            $(this).find('.itemTaxPrice').val(total.toFixed(2));
            $(this).find('.amount').html((totalPrice + total).toFixed(2));
        });
    }

    function calculateTax(rate, price, isSameState) {
        const totalTax = (rate / 100) * price;
        if (taxType === 'vat') {
            return { total: totalTax, cgst: 0, sgst: 0, igst: 0 };
        }
        return isSameState
            ? { total: totalTax, cgst: totalTax / 2, sgst: totalTax / 2, igst: 0 }
            : { total: totalTax, cgst: 0, sgst: 0, igst: totalTax };
    }

    function calculateItemAmount(el) {
        var quantity = parseFloat(el.find('.quantity').val()) || 0;
        var price = parseFloat(el.find('.price').val()) || 0;
        var discount = parseFloat(el.find('.discount').val()) || 0;
        var taxRate = parseFloat(el.find('.itemTaxRate').val()) || 0;

        var totalItemPrice = (quantity * price) - discount;
        var itemTaxPrice = (taxRate / 100) * totalItemPrice;
        el.find('.itemTaxPrice').val(itemTaxPrice.toFixed(2));
        el.find('.amount').html((totalItemPrice + itemTaxPrice).toFixed(2));
    }

    function updateTotals() {
        var totalItemPrice = $('.quantity').toArray().reduce((sum, q, i) => sum + (parseFloat($(q).val()) * parseFloat($('.price').eq(i).val())), 0);
        var totalItemTaxPrice = $('.itemTaxPrice').toArray().reduce((sum, el) => sum + parseFloat($(el).val() || 0), 0);
        var totalItemDiscountPrice = $('.discount').toArray().reduce((sum, el) => sum + parseFloat($(el).val() || 0), 0);
        var subTotal = $('.amount').toArray().reduce((sum, el) => sum + parseFloat($(el).html() || 0), 0);

        $('.subTotal').html(totalItemPrice.toFixed(2));
        $('.totalTax').html(totalItemTaxPrice.toFixed(2));
        $('.totalDiscount').html(totalItemDiscountPrice.toFixed(2));
        $('.totalAmount').html(subTotal.toFixed(2));
    }

    function preserveItemSelection() {
        $('.item option').prop('hidden', false);
        $('.item :selected').each(function () {
            var id = $(this).val();
            if (id) {
                $('.item').not(this).find("option[value=" + id + "]").prop('hidden', true);
            }
        });
    }

    $(document).ready(function () {
        updateTaxDisplay();
        var customerId = '{{ $customerId ?? 0 }}';
        if (customerId > 0) {
            $('#customer').val(customerId).change();
        }
    });
</script>

@endpush

@push('css-page')
    <style>
        .taxes {
            display: block !important;
            overflow: visible !important;
            min-height: 20px;
            margin-bottom: 5px;
        }
        .tax-display {
            display: flex !important;
            flex-wrap: wrap;
            gap: 8px;
            align-items: center;
        }
        .taxes .badge {
            display: inline-block !important;
            white-space: normal !important;
            background-color: white;
            color: black;
            padding: 5px 10px;
            font-size: 0.85rem;
            border-radius: 5px;
        }
        @media (max-width: 768px) {
            .taxes { min-height: auto; margin-bottom: 10px; }
            .tax-display { flex-direction: column; gap: 10px; }
        }
    </style>
@endpush

@section('content')
    <div class="row">
        {{ Form::open(array('url' => 'invoice', 'class' => 'w-100 needs-validation', 'novalidate')) }}
        <div class="col-12">
            <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">
            <input type="hidden" name="company_state" value="{{ $company_state }}">
            <input type="hidden" name="billing_state" value="{{ $billing_state }}">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
                            <div class="form-group" id="customer-box">
                                {{ Form::label('customer_id', __('Customer'), ['class' => 'form-label']) }}<x-required></x-required>
                                {{ Form::select('customer_id', $customers, $customerId, array('class' => 'form-control select', 'id' => 'customer', 'data-url' => route('invoice.customer'), 'required' => 'required')) }}
                                <div class="text-xs mt-1">
                                    {{ __('Create customer here.') }} <a href="{{ route('customer.index') }}"><b>{{ __('Create customer') }}</b></a>
                                </div>
                            </div>
                            <div id="customer_detail" class="d-none"></div>
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        {{ Form::label('issue_date', __('Issue Date'), ['class' => 'form-label']) }}<x-required></x-required>
                                        <div class="form-icon-user">
                                            {{ Form::date('issue_date', null, array('class' => 'form-control', 'required' => 'required')) }}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        {{ Form::label('due_date', __('Due Date'), ['class' => 'form-label']) }}<x-required></x-required>
                                        <div class="form-icon-user">
                                            {{ Form::date('due_date', null, array('class' => 'form-control', 'required' => 'required')) }}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        {{ Form::label('invoice_number', __('Invoice Number'), ['class' => 'form-label']) }}
                                        <div class="form-icon-user">
                                            <input type="text" class="form-control" value="{{$invoice_number}}" readonly>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        {{ Form::label('category_id', __('Category'), ['class' => 'form-label']) }}<x-required></x-required>
                                        {{ Form::select('category_id', $category, null, array('class' => 'form-control select', 'required' => 'required')) }}
                                        <div class="text-xs mt-1">
                                            {{ __('Create category here.') }} <a href="{{ route('product-category.index') }}"><b>{{ __('Create category') }}</b></a>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        {{ Form::label('ref_number', __('Ref Number'), ['class' => 'form-label']) }}
                                        <div class="form-icon-user">
                                            <span><i class="ti ti-joint"></i></span>
                                            {{ Form::text('ref_number', '', array('class' => 'form-control', 'placeholder' => __('Enter Ref Number'))) }}
                                        </div>
                                    </div>
                                </div>
                                @if(!$customFields->isEmpty())
                                    @include('customFields.formBuilder')
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12">
            <h5 class="d-inline-block mb-4">{{__('Product & Services')}}</h5>
            <div class="card repeater">
                <div class="item-section py-2">
                    <div class="row justify-content-between align-items-center">
                        <div class="col-md-12 d-flex align-items-center justify-content-between justify-content-md-end">
                            <div class="all-button-box me-2">
                                <a href="#" data-repeater-create="" class="btn btn-primary d-flex align-items-center gap-1 justify-content-center">
                                    <i class="ti ti-plus"></i> {{__('Add item')}}
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body table-border-style mt-2">
                    <div class="table-responsive">
                        <table class="table mb-0 table-custom-style" data-repeater-list="items" id="sortable-table">
                            <thead>
                                <tr>
                                    <th>{{__('Items')}}<x-required></x-required></th>
                                    <th>{{__('Quantity')}}<x-required></x-required></th>
                                    <th>{{__('Price')}}<x-required></x-required></th>
                                    <th>{{__('Discount')}}<x-required></x-required></th>
                                    <th>{{__('Tax')}} (%)</th>
                                    <th class="text-end">{{__('Amount')}} <br><small class="text-danger font-weight-bold">{{__('after tax & discount')}}</small></th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody class="ui-sortable" data-repeater-item>
                                <tr>
                                    <td width="25%" class="form-group pt-0">
                                        {{ Form::select('item', $product_services, '', array('class' => 'form-control select2 item', 'data-url' => route('invoice.product'), 'required' => 'required')) }}
                                    </td>
                                    <td>
                                        <div class="form-group price-input input-group search-form">
                                            {{ Form::number('quantity', '', array('class' => 'form-control quantity', 'required' => 'required', 'placeholder' => __('Qty'))) }}
                                            <span class="unit input-group-text bg-transparent"></span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="form-group price-input input-group search-form">
                                            {{ Form::number('price', '', array('class' => 'form-control price', 'required' => 'required', 'placeholder' => __('Price'))) }}
                                            <span class="input-group-text bg-transparent">{{\Auth::user()->currencySymbol()}}</span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="form-group price-input input-group search-form">
                                            {{ Form::number('discount', '', array('class' => 'form-control discount', 'required' => 'required', 'placeholder' => __('Discount'))) }}
                                            <span class="input-group-text bg-transparent">{{\Auth::user()->currencySymbol()}}</span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="form-group">
                                            <div class="taxes"></div>
                                            {{ Form::hidden('tax', '', array('class' => 'form-control tax')) }}
                                            {{ Form::hidden('itemTaxPrice', '', array('class' => 'form-control itemTaxPrice')) }}
                                            {{ Form::hidden('itemTaxRate', '', array('class' => 'form-control itemTaxRate')) }}
                                        </div>
                                    </td>
                                    <td class="text-end amount">0.00</td>
                                    <td>
                                        <div class="action-btn me-2">
                                            <a href="#" class="ti ti-trash text-white btn btn-sm repeater-action-btn bg-danger ms-2" data-bs-toggle="tooltip" title="{{ __('Delete') }}" data-repeater-delete></a>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2">
                                        <div class="form-group">
                                            {{ Form::textarea('description', null, ['class' => 'form-control pro_description', 'rows' => '2', 'placeholder' => __('Description')]) }}
                                        </div>
                                    </td>
                                    <td colspan="5"></td>
                                </tr>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td> </td>
                                    <td> </td>
                                    <td> </td>
                                    <td></td>
                                    <td><strong>{{__('Sub Total')}} ({{\Auth::user()->currencySymbol()}})</strong></td>
                                    <td class="text-end subTotal">0.00</td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td> </td>
                                    <td> </td>
                                    <td> </td>
                                    <td></td>
                                    <td><strong>{{__('Discount')}} ({{\Auth::user()->currencySymbol()}})</strong></td>
                                    <td class="text-end totalDiscount">0.00</td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td> </td>
                                    <td> </td>
                                    <td> </td>
                                    <td></td>
                                    <td><strong>{{__('Tax')}} ({{\Auth::user()->currencySymbol()}})</strong></td>
                                    <td class="text-end totalTax">0.00</td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td> </td>
                                    <td> </td>
                                    <td> </td>
                                    <td> </td>
                                    <td class="blue-text"><strong>{{__('Total Amount')}} ({{\Auth::user()->currencySymbol()}})</strong></td>
                                    <td class="text-end totalAmount blue-text">0.00</td>
                                    <td></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <input type="button" value="{{__('Cancel')}}" onclick="location.href = '{{route("invoice.index")}}';" class="btn btn-secondary me-2">
            <input type="submit" value="{{__('Create')}}" class="btn btn-primary">
        </div>
        {{ Form::close() }}
    </div>
@endsection
