<?php

namespace App\Exports;

use App\Models\Customer;
use App\Models\EWayBill;
use App\Models\ProductServiceCategory;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class EWayBillExport implements FromCollection, WithHeadings
{
    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        $data = EWayBill::where('created_by', \Auth::user()->creatorId())->get();

        foreach($data as $k => $ewaybill)
        {
            unset($ewaybill->id, $ewaybill->created_by, $ewaybill->shipping_display,$ewaybill->discount_apply,$ewaybill->created_at,$ewaybill->updated_at);
            $data[$k]["ewaybill_id"] = \Auth::user()->ebillNumberFormat($ewaybill->ewaybill_id);
            $data[$k]["customer_id"] = (isset($ewaybill->customer) && isset($ewaybill->customer->name)) ? $ewaybill->customer->name : '';
            $data[$k]['category_id'] = ProductServiceCategory::where('type', 'income')->where('id',$ewaybill->category_id)->first()->name;
            $data[$k]["status"]       = EWayBill::$statues[$ewaybill->status];

        }

        return $data;
    }

    public function headings(): array
    {
        return [
            "ewaybill No",
            "Customer",
            "Issue Date",
            "Due Date",
            "Send Date",
            "Category",
            "Ref Number",
            "Status",

        ];
    }
}
