@php
$logo = \App\Models\Utility::get_file('uploads/logo');
$company_logo = \App\Models\Utility::GetLogo();
$creatorId = \Auth::user()->creatorId();
$setting = DB::table('settings')->where('created_by', $creatorId)->pluck('value', 'name')->toArray();
$settings_data = isset($ewaybill) ? \App\Models\Utility::settingsById($ewaybill->created_by) : \App\Models\Utility::settingsById($creatorId);
$company_state = strtolower(trim($settings_data['company_state'] ?? 'defaultstate'));
$billing_state = isset($customer) ? strtolower(trim($customer->billing_state ?? '')) : '';
@endphp

@extends('layouts.admin')

@section('page-title')
    {{__('EWayBill Edit')}}
@endsection

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{route('dashboard')}}">{{__('Dashboard')}}</a></li>
    <li class="breadcrumb-item"><a href="{{route('ewaybill.index')}}">{{__('EWayBill')}}</a></li>
    <li class="breadcrumb-item">{{__('EWayBill Edit')}}</li>
@endsection

@push('script-page')
    <script src="{{asset('js/jquery-ui.min.js')}}"></script>
    <script src="{{asset('js/jquery.repeater.min.js')}}"></script>


<script>
$(document).ready(function () {
    const selector = "body";

    if ($(selector + " .repeater").length) {
        const $dragAndDrop = $("body .repeater tbody").sortable({ handle: '.sort-handler' });
        const $repeater = $(selector + ' .repeater').repeater({
            initEmpty: true,
            defaultValues: { 'status': 1 },
            show: function () {
                $(this).slideDown();
                if ($(this).find('input.multi').length) {
                    $(this).find('input.multi').MultiFile({ max: 3, accept: 'png|jpg|jpeg', max_size: 2048 });
                }
                updateItemOptions();
                setDefaultTax($(this));
            },
            hide: function (deleteElement) {
                if (confirm('Are you sure you want to delete this element?')) {
                    const el = $(this);
                    const id = el.find('.id').val();
                    if (id) {
                        $.ajax({
                            url: '{{ route('ewaybill.product.destroy') }}',
                            type: 'POST',
                            headers: { 'X-CSRF-TOKEN': $('#token').val() },
                            data: { id },
                            success: function (data) {
                                updateItemOptions();
                                show_toastr(data.status ? 'success' : 'error', data.message);
                            }
                        });
                    }
                    $(this).slideUp(deleteElement, function () {
                        $(this).remove();
                        calculateTotals();
                    });
                }
            },
            ready: function (setIndexes) {
                $dragAndDrop.on('drop', setIndexes);
            },
            isFirstItemUndeletable: true
        });

        const value = $(selector + " .repeater").attr('data-value');
        if (value) {
            const items = JSON.parse(value);
            $repeater.setList(items);
            items.forEach(item => {
                const tr = $('#sortable-table .id[value="' + item.id + '"]').parent();
                tr.find('.item').val(item.product_id);
                changeItem(tr.find('.item'));
            });
        }
    }

    $(document).on('change', '#customer', function () {
        const customerId = $(this).val();
        const url = $(this).data('url');

        if (!customerId) return resetCustomerDisplay();

        $.ajax({
            url, type: 'POST',
            headers: { 'X-CSRF-TOKEN': $('#token').val() },
            data: { id: customerId },
            success: function (response) {
                if (response.error) return resetCustomerDisplay();
                $('input[name="billing_state"]').val(response.state?.toLowerCase().trim());
                $('#customer_detail').html(response.view).removeClass('d-none').addClass('d-block');
                $('#customer-box').removeClass('d-block').addClass('d-none');
                updateTaxDisplay();
            },
            error: resetCustomerDisplay
        });
    });

    function resetCustomerDisplay() {
        $('#customer-box').removeClass('d-none').addClass('d-block');
        $('#customer_detail').removeClass('d-block').addClass('d-none').html('');
        $('input[name="billing_state"]').val('');
        updateTaxDisplay();
    }

    $(document).on('click', '#remove', resetCustomerDisplay);

    $(document).on('change', '.item', function () {
        changeItem($(this));
        updateItemOptions();
    });

    $(document).on('click', '[data-repeater-create]', updateItemOptions);

    $(document).on('keyup change', '.quantity, .price, .discount', function () {
        const row = $(this).closest('tr');
        calculateItemAmount(row);
        calculateTotals();
    });

    function updateItemOptions() {
        $('.item option').prop('hidden', false);
        $('.item :selected').each(function () {
            const id = $(this).val();
            if (id) $('.item').not(this).find(`option[value=${id}]`).prop('hidden', true);
        });
    }

    function setDefaultTax(row) {
        const defaultTaxRate = $('.itemTaxRate').first().val() || 0;
        const defaultTaxHtml = $('.taxes').first().html() || '<span class="badge">No Tax Data</span>';
        row.find('.itemTaxRate').val(defaultTaxRate);
        row.find('.taxes').html(defaultTaxHtml);
        calculateItemAmount(row);
    }

    function calculateItemAmount(row) {
        const quantity = parseFloat(row.find('.quantity').val()) || 0;
        const price = parseFloat(row.find('.price').val()) || 0;
        const discount = parseFloat(row.find('.discount').val()) || 0;
        const taxRate = parseFloat(row.find('.itemTaxRate').val()) || 0;

        const subtotal = (quantity * price) - discount;
        const taxAmount = (taxRate / 100) * subtotal;

        row.find('.itemTaxPrice').val(taxAmount.toFixed(2));
        row.find('.amount').html((subtotal + taxAmount).toFixed(2));
    }

    function calculateTotals() {
        let subTotal = 0, totalTax = 0, totalDiscount = 0;
        $('.repeater tbody tr').each(function () {
            const quantity = parseFloat($(this).find('.quantity').val()) || 0;
            const price = parseFloat($(this).find('.price').val()) || 0;
            const discount = parseFloat($(this).find('.discount').val()) || 0;
            const taxAmount = parseFloat($(this).find('.itemTaxPrice').val()) || 0;
            subTotal += quantity * price;
            totalDiscount += discount;
            totalTax += taxAmount;
        });
        $('.subTotal').html(subTotal.toFixed(2));
        $('.totalDiscount').html(totalDiscount.toFixed(2));
        $('.totalTax').html(totalTax.toFixed(2));
        $('.totalAmount').html((subTotal - totalDiscount + totalTax).toFixed(2));
    }

    function changeItem(element) {
        const productId = element.val();
        const url = element.data('url');
        const row = element.closest('tr');
        const ewaybillId = '{{ $ewaybill->id }}';

        $.ajax({
            url, type: 'POST',
            headers: { 'X-CSRF-TOKEN': $('#token').val() },
            data: { product_id: productId },
            success: function (data) {
                const product = JSON.parse(data);
                $.ajax({
                    url: '{{ route('ewaybill.items') }}',
                    type: 'GET',
                    headers: { 'X-CSRF-TOKEN': $('#token').val() },
                    data: { ewaybill_id: ewaybillId, product_id: productId },
                    success: function (data) {
                        const itemDetails = JSON.parse(data);

                        row.find('.quantity').val(itemDetails?.quantity || 1);
                        row.find('.price').val(itemDetails?.price || product.product.sale_price);
                        row.find('.discount').val(itemDetails?.discount || 0);
                        row.find('.pro_description').val(itemDetails?.description || product.product.description);

                        let totalItemTaxRate = 0, taxHtml = '';
                        let cgstRate = 0, sgstRate = 0, igstRate = 0, vatRate = 0;

                       taxHtml = '';
if (product.taxes && Array.isArray(product.taxes)) {
    product.taxes.forEach(tax => {
        const name = tax.name.toLowerCase();
        if (name.includes('vat')) vatRate = parseFloat(tax.rate) || 0;
        if (name.includes('cgst')) cgstRate = parseFloat(tax.rate) || 0;
        if (name.includes('sgst')) sgstRate = parseFloat(tax.rate) || 0;
        if (name.includes('igst')) igstRate = parseFloat(tax.rate) || 0;
    });
}console.log('Tax debug:', { vatRate, cgstRate, sgstRate, igstRate, productTaxes: product.taxes });


                        const companyState = $('#company_state').val()?.toLowerCase().trim() || '';
                        const billingState = $('input[name="billing_state"]').val()?.toLowerCase().trim() || '';
                        const taxType = $('#tax_type').val()?.toLowerCase() || 'gst';

                       const isSameState = companyState && billingState && companyState === billingState;

const defaultVatRate = 5;
  cgstRate = parseFloat(cgstRate) || 0;
sgstRate = parseFloat(sgstRate) || 0;
if (taxType === 'vat') {
  

if (vatRate === 0 && (cgstRate > 0 || sgstRate > 0)) {
    vatRate = cgstRate + sgstRate;
}


    if (vatRate > 0) {
        taxHtml = `<span class="badge ">VAT (${vatRate.toFixed(2)}%)</span>`;
        totalItemTaxRate = vatRate;
    } else {
        taxHtml = `<span class="badge ">Default VAT (${defaultVatRate}%)</span>`;
        totalItemTaxRate = defaultVatRate;
    }
}
 else if (taxType === 'gst') {
    if (isSameState) {
        if (cgstRate > 0 || sgstRate > 0) {
            if (cgstRate > 0) {
                taxHtml += `<span class="badge ">CGST (${cgstRate.toFixed(2)}%)</span> `;
            }
            if (sgstRate > 0) {
                taxHtml += `<span class="badge ">SGST (${sgstRate.toFixed(2)}%)</span>`;
            }
            totalItemTaxRate = cgstRate + sgstRate;
        } else {
            taxHtml = '<span class="badge ">No CGST/SGST Found</span>';
        }
    } else {
        if (igstRate > 0) {
            taxHtml = `<span class="badge ">IGST (${igstRate.toFixed(2)}%)</span>`;
            totalItemTaxRate = igstRate;
        } else {
            taxHtml = '<span class="badge ">No IGST Found</span>';
        }
    }
} else {
    taxHtml = '<span class="badge ">No Tax Type Selected</span>';
}


                        row.find('.taxes').html(taxHtml);
                        row.find('.itemTaxRate').val(totalItemTaxRate.toFixed(2));
                        row.find('.unit').html(product.unit || '');
                        calculateItemAmount(row);
                        calculateTotals();
                    }
                });
            }
        });
    }

    function updateTaxDisplay() {
        $('.repeater tbody tr').each(function () {
            changeItem($(this).find('.item')); // re-evaluate tax logic
        });
    }

    if ($('#customer').val()) $('#customer').trigger('change');
});
</script>


   <script>
    function fetchEWayBillNumberIfNeeded() {
        const distance = parseFloat($('#delivery_distance').val()) || 0;
        const $ewayField = $('#e_way_bill_number');
        const $message = $('#e_way_bill_message');

        if (distance <= 4) {
            $ewayField.val('');
            $message.text('E-Way Bill Number is not required for distances 4 km or less.').addClass('text-danger');
            return;
        }

        // If already filled (i.e., during edit), do NOT regenerate
        if ($ewayField.val().trim()) {
            $message.text('');
            return;
        }

        // AJAX to get formatted ewaybill number
        $.ajax({
            url: '{{ route("ewaybill.generate.number") }}',
            method: 'POST',
            data: {
                delivery_distance: distance,
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                if (response.e_way_bill_number) {
                    $ewayField.val(response.e_way_bill_number);
                    $message.text('');
                }
            },
            error: function() {
                $message.text('Failed to generate E-Way Bill Number.').addClass('text-danger');
            }
        });
    }

    $(document).ready(function () {
        $('#delivery_distance').on('keyup change', function () {
            fetchEWayBillNumberIfNeeded();
        });

        // Trigger on page load to keep values pre-filled on edit
        fetchEWayBillNumberIfNeeded();
    });
</script>



@endpush

@push('css-page')
    <style>
        .taxes {
            display: block !important;
            overflow: visible !important;
            min-height: 20px;
            margin-bottom: 5px;
        }
        .tax-display {
            display: flex !important;
            flex-wrap: wrap;
            gap: 8px;
            align-items: center;
        }
        .taxes .badge {
            display: inline-block !important;
            white-space: normal !important;
            background-color: white;
            color: black;
            padding: 5px 10px;
            font-size: 0.85rem;
            border-radius: 5px;
        }
        @media (max-width: 768px) {
            .taxes { min-height: auto; margin-bottom: 10px; }
            .tax-display { flex-direction: column; gap: 10px; }
        }
    </style>
@endpush

@section('content')
    <div class="row">
        @if (session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif
        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif
        @if (isset($categoryWarning))
            <div class="alert alert-warning alert-dismissible fade show" role="alert">
                {{ $categoryWarning }} <a href="{{ route('product-category.index') }}" class="alert-link">{{ __('Create category') }}</a>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        {{ Form::model($ewaybill, array('route' => array('ewaybill.update', $ewaybill->id), 'method' => 'PUT', 'class' => 'w-100 needs-validation', 'novalidate')) }}
        <div class="col-12">
            <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">
            <input type="hidden" id="company_state" name="company_state" value="{{ $company_state }}">
            <input type="hidden" name="billing_state" value="{{ $billing_state }}">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group" id="customer-box">
                                {{ Form::label('customer_id', __('Customer'), ['class' => 'form-label']) }}<x-required></x-required>
                                {{ Form::select('customer_id', $customers, $ewaybill->customer_id, array('class' => 'form-control select', 'id' => 'customer', 'data-url' => route('ewaybill.customer'), 'required' => 'required')) }}
                                <div class="text-xs mt-1">
                                    {{ __('Create customer here.') }} <a href="{{ route('customer.index') }}"><b>{{ __('Create customer') }}</b></a>
                                </div>
                            </div>
                            <div id="customer_detail" class="d-none"></div>
                        </div>
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        {{ Form::label('issue_date', __('Issue Date'), ['class' => 'form-label']) }}<x-required></x-required>
                                        <div class="form-icon-user">
                                            {{ Form::date('issue_date', null, array('class' => 'form-control', 'required' => 'required')) }}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        {{ Form::label('due_date', __('Due Date'), ['class' => 'form-label']) }}<x-required></x-required>
                                        <div class="form-icon-user">
                                            {{ Form::date('due_date', null, array('class' => 'form-control', 'required' => 'required')) }}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        {{ Form::label('ewaybill_number', __('EWaybill Id'), ['class' => 'form-label']) }}
                                        <div class="form-icon-user">
                                            <input type="text" class="form-control" value="{{$ewaybill_number}}" readonly>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        {{ Form::label('category_id', __('Category'), ['class' => 'form-label']) }}<x-required></x-required>
                                        {{ Form::select('category_id', $category, $ewaybill->category_id, array('class' => 'form-control select', 'required' => 'required', 'disabled' => $category->isEmpty())) }}
                                        <div class="text-xs mt-1">
                                            {{ __('Create category here.') }} <a href="{{ route('product-category.index') }}"><b>{{ __('Create category') }}</b></a>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        {{ Form::label('ref_number', __('Ref Number'), ['class' => 'form-label']) }}
                                        <div class="form-icon-user">
                                            <span><i class="ti ti-joint"></i></span>
                                            {{ Form::text('ref_number', null, array('class' => 'form-control', 'placeholder' => __('Enter Ref Number'))) }}
                                        </div>
                                    </div>
                                </div>
      <div class="col-md-6">
    <div class="form-group">
        {{ Form::label('delivery_distance', __('Delivery Distance (km)'), ['class' => 'form-label']) }}<x-required />
        <input type="number" step="0.1" name="delivery_distance" id="delivery_distance"
            class="form-control @error('delivery_distance') is-invalid @enderror"
            value="{{ old('delivery_distance', $ewaybill->delivery_distance ?? '') }}" required>

        {{-- Show error below the field --}}
        @error('delivery_distance')
            <span class="invalid-feedback d-block" role="alert">
                <strong>{{ $message }}</strong>
            </span>
        @enderror
    </div>
</div>




                                @if(!$customFields->isEmpty())
                                    @include('customFields.formBuilder')
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12">
            <h5 class="d-inline-block mb-4">{{__('Product & Services')}}</h5>
            <div class="card repeater" data-value='{{ json_encode($ewaybill->items) }}'>
                <div class="item-section py-2">
                    <div class="row justify-content-between align-items-center">
                        <div class="col-md-12 d-flex align-items-center justify-content-between justify-content-md-end">
                            <div class="all-button-box me-2">
                                <a href="#" data-repeater-create class="btn btn-primary d-flex align-items-center gap-1 justify-content-center">
                                    <i class="ti ti-plus"></i> {{__('Add item')}}
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body table-border-style mt-2">
                    <div class="table-responsive">
                        <table class="table mb-0 table-custom-style" data-repeater-list="items" id="sortable-table">
                            <thead>
                                <tr>
                                    <th>{{__('Items')}}<x-required></x-required></th>
                                    <th>{{__('Quantity')}}<x-required></x-required></th>
                                    <th>{{__('Price')}}<x-required></x-required></th>
                                    <th>{{__('Discount')}}<x-required></x-required></th>
                                    <th>{{__('Tax')}} (%)</th>
                                    <th class="text-end">{{__('Amount')}} <br><small class="text-danger font-weight-bold">{{__('after tax & discount')}}</small></th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody class="ui-sortable" data-repeater-item>
                                <tr>
                                    {{ Form::hidden('id', null, array('class' => 'form-control id')) }}
                                    <td width="25%" class="form-group pt-0">
                                        {{ Form::select('item', $product_services, null, array('class' => 'form-control select item', 'data-url' => route('ewaybill.product'))) }}
                                    </td>
                                    <td>
                                        <div class="form-group price-input input-group search-form">
                                            {{ Form::number('quantity', null, array('class' => 'form-control quantity', 'required' => 'required', 'placeholder' => __('Qty'))) }}
                                            <span class="unit input-group-text bg-transparent"></span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="form-group price-input input-group search-form">
                                            {{ Form::number('price', null, array('class' => 'form-control price', 'required' => 'required', 'placeholder' => __('Price'))) }}
                                            <span class="input-group-text bg-transparent">{{\Auth::user()->currencySymbol()}}</span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="form-group price-input input-group search-form">
                                            {{ Form::number('discount', null, array('class' => 'form-control discount', 'required' => 'required', 'placeholder' => __('Discount'))) }}
                                            <span class="input-group-text bg-transparent">{{\Auth::user()->currencySymbol()}}</span>
                                        </div>
                                    </td>
                                    <td>
                                    <div class="form-group">
    {{-- Hidden fields for JS --}}
    <input type="hidden" id="tax_type" value="{{ strtolower(Utility::getValByName('tax_type') ?? 'gst') }}">
    <input type="hidden" id="company_state" value="{{ strtolower($settings['company_state'] ?? '') }}">

    {{-- Tax Badge --}}
    @php
        $taxType = strtolower(Utility::getValByName('tax_type') ?? 'gst');
        $vatRate = isset($billItem) ? ($billItem->itemTaxRate ?? 0) : 0;
        $gstRate = isset($billItem) ? ($billItem->itemTaxRate ?? 0) : 0;
    @endphp

    <div class="taxes">
        @if($taxType === 'vat')
            <span class="badge badge-success">
                VAT ({{ number_format($vatRate, 2) }}%)
            </span>
        @else
            <span class="badge badge-primary">
                CGST ({{ number_format($gstRate / 2, 2) }}%)
            </span>
            <span class="badge badge-primary">
                SGST ({{ number_format($gstRate / 2, 2) }}%)
            </span>
        @endif
    </div>

    {{-- Hidden form inputs for tax calculations --}}
    {{ Form::hidden('tax', '', ['class' => 'form-control tax']) }}
    {{ Form::hidden('itemTaxPrice', '', ['class' => 'form-control itemTaxPrice']) }}
    {{ Form::hidden('itemTaxRate', $vatRate ?: $gstRate, ['class' => 'form-control itemTaxRate']) }}
</div>
                                    </td>
                                    <td class="text-end amount">0.00</td>
                                    <td>
                                        <div class="action-btn me-2">
                                            <a href="#" class="ti ti-trash text-white btn btn-sm repeater-action-btn bg-danger ms-2" data-bs-toggle="tooltip" title="{{ __('Delete') }}" data-repeater-delete></a>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2">
                                        <div class="form-group">
                                            {{ Form::textarea('description', null, array('class' => 'form-control pro_description', 'rows' => '2', 'placeholder' => __('Description'))) }}
                                        </div>
                                    </td>
                                    <td colspan="5"></td>
                                </tr>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td> </td>
                                    <td> </td>
                                    <td> </td>
                                    <td></td>
                                    <td><strong>{{__('Sub Total')}} ({{\Auth::user()->currencySymbol()}})</strong></td>
                                    <td class="text-end subTotal">0.00</td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td> </td>
                                    <td> </td>
                                    <td> </td>
                                    <td></td>
                                    <td><strong>{{__('Discount')}} ({{\Auth::user()->currencySymbol()}})</strong></td>
                                    <td class="text-end totalDiscount">0.00</td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td> </td>
                                    <td> </td>
                                    <td> </td>
                                    <td></td>
                                    <td><strong>{{__('Tax')}} ({{\Auth::user()->currencySymbol()}})</strong></td>
                                    <td class="text-end totalTax">0.00</td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td> </td>
                                    <td> </td>
                                    <td> </td>
                                    <td> </td>
                                    <td class="blue-text"><strong>{{__('Total Amount')}} ({{\Auth::user()->currencySymbol()}})</strong></td>
                                    <td class="text-end totalAmount blue-text">0.00</td>
                                    <td></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <input type="button" value="{{__('Cancel')}}" onclick="location.href = '{{route('ewaybill.index')}}';" class="btn btn-secondary me-2">
            <input type="submit" value="{{__('Update')}}" class="btn btn-primary">
        </div>
        {{ Form::close() }}
    </div>
@endsection