@php
$logo = \App\Models\Utility::get_file('uploads/logo');
$company_logo = \App\Models\Utility::GetLogo();
$creatorId = \Auth::user()->creatorId();
$setting = DB::table('settings')->where('created_by', $creatorId)->pluck('value', 'name')->toArray();
$settings_data = \App\Models\Utility::settingsById($creatorId);
$company_state = strtolower(trim($settings_data['company_state'] ?? 'defaultstate'));
$billing_state = $customer ? strtolower(trim($customer->billing_state ?? '')) : '';
@endphp

@extends('layouts.admin')

@section('page-title')
    {{__('EWayBill Create')}}
@endsection

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{route('dashboard')}}">{{__('Dashboard')}}</a></li>
    <li class="breadcrumb-item"><a href="{{route('ewaybill.index')}}">{{__('EWayBill')}}</a></li>
    <li class="breadcrumb-item">{{__('EWayBill Create')}}</li>
@endsection

@push('script-page')
    <script src="{{asset('js/jquery-ui.min.js')}}"></script>
    <script src="{{asset('js/jquery.repeater.min.js')}}"></script>
    <script>
    var selector = "body";
    var taxType = "{{ $tax_type }}"; // Pass tax type from PHP to JS (vat or gst)

    if ($(selector + " .repeater").length) {
        var $dragAndDrop = $("body .repeater tbody").sortable({
            handle: '.sort-handler'
        });
        var $repeater = $(selector + ' .repeater').repeater({
            initEmpty: false,
            defaultValues: { 'status': 1 },
            show: function () {
                $(this).slideDown();
                var $row = $(this).closest('tr');
                $row.find('.quantity').val(1);
                $row.find('.price').val(0);
                $row.find('.discount').val(0);
                var file_uploads = $(this).find('input.multi');
                if (file_uploads.length) {
                    file_uploads.MultiFile({
                        max: 3,
                        accept: 'png|jpg|jpeg',
                        max_size: 2048
                    });
                }
                updateTaxDisplay($row);
                console.log('Repeater Show - New Row Added');
                preserveItemSelection();
            },
            hide: function (deleteElement) {
                if (confirm('Are you sure you want to delete this element?')) {
                    $(this).slideUp(deleteElement);
                    $(this).remove();
                    updateTotals();
                    console.log('Repeater Hide - Row Removed');
                    preserveItemSelection();
                }
            },
            ready: function (setIndexes) {
                $dragAndDrop.on('drop', setIndexes);
            },
            isFirstItemUndeletable: true
        });
        var value = $(selector + " .repeater").attr('data-value');
        if (value && value.length !== 0) {
            $repeater.setList(JSON.parse(value));
        }
    }

    $(document).on('change', '#customer', function () {
        console.log('Customer Change Triggered');
        const id = $(this).val();
        const url = $(this).data('url');

        if (!id) {
            resetCustomerDisplay();
            return;
        }

        $.ajax({
            url: url,
            type: 'POST',
            headers: { 'X-CSRF-TOKEN': $('#token').val() },
            data: { id },
            success: function (response) {
                console.log('Server Response:', response);
                if (response.error) {
                    console.error('Error Response:', response.error);
                    resetCustomerDisplay();
                    return;
                }

                $('input[name="billing_state"]').val((response.state || 'unknown').toLowerCase().trim());
                $('#customer_detail').html(response.view).removeClass('d-none').addClass('d-block');
                $('#customer-box').removeClass('d-block').addClass('d-none');
                updateTaxDisplay();
            },
            error: function (xhr) {
                console.error('Error Fetching Customer Details:', xhr.responseText);
                resetCustomerDisplay();
            }
        });
    });

    function resetCustomerDisplay() {
        console.log('Resetting Customer Display');
        $('#customer-box').removeClass('d-none').addClass('d-block');
        $('#customer_detail').removeClass('d-block').addClass('d-none').html('');
        $('input[name="billing_state"]').val('');
        updateTaxDisplay();
    }

    $(document).on('click', '#remove', function () {
        resetCustomerDisplay();
        console.log('Customer Removed - Billing State Cleared');
    });

    $(document).on('change', '.item', function () {
        var itemId = $(this).val();
        var url = $(this).data('url');
        var $row = $(this).closest('tr');
        $.ajax({
            url: url,
            type: 'POST',
            headers: { 'X-CSRF-TOKEN': $('#token').val() },
            data: { 'product_id': itemId },
            cache: false,
            success: function (data) {
                var item = JSON.parse(data);
                console.log('Item AJAX Response:', item);

                $row.find('.quantity').val(1);
                $row.find('.price').val(item.product.sale_price || 0);
                $row.find('.pro_description').val(item.product.description || '');
                $row.find('.discount').val(0);
                $row.find('.unit').html(item.unit || '');

                var totalItemTaxRate = getTotalItemTaxRate(item.taxes);
                $row.find('.itemTaxRate').val(totalItemTaxRate.toFixed(2));
                $row.find('.tax').val(item.taxes ? item.taxes.map(t => t.id).join(',') : '');

                setTaxBadge($row, item.taxes);
                calculateItemAmount($row);
                updateTaxDisplay($row);
                updateTotals();
                preserveItemSelection();
            },
            error: function (xhr, status, error) {
                console.error('Item AJAX Error:', error, 'Response:', xhr.responseText);
            }
        });
    });

    $(document).on('click', '[data-repeater-create]', preserveItemSelection);

    $(document).on('keyup change', '.quantity, .price, .discount', function () {
        var $row = $(this).closest('tr');
        calculateItemAmount($row);
        updateTaxDisplay($row);
        updateTotals();
        console.log('Input Changed - Row Updated');
    });

    function updateTaxDisplay($row = null) {
        const companyState = $('input[name="company_state"]').val().toLowerCase().trim();
        const billingState = $('input[name="billing_state"]').val().toLowerCase().trim() || 'unknown';
        const isSameState = companyState === billingState;

        console.log('Updating Tax Display - Tax Type:', taxType);

        ($row || $('.repeater tbody tr')).each(function () {
            const $row = $(this);
            const taxRate = parseFloat($row.find('.itemTaxRate').val()) || 0;
            const quantity = parseFloat($row.find('.quantity').val()) || 0;
            const price = parseFloat($row.find('.price').val()) || 0;
            const discount = parseFloat($row.find('.discount').val()) || 0;
            const totalPrice = quantity * price - discount;

            const taxAmounts = calculateTax(taxRate, totalPrice, isSameState);

            let taxHtml = '';
            if (taxType === 'vat') {
                taxHtml = `<span class="badge">VAT (${taxRate.toFixed(2)}%)</span>`;
            } else if (billingState === 'unknown' || !companyState) {
                taxHtml = '<span class="badge">No State Data</span>';
            } else if (isSameState) {
                taxHtml = `<span class="badge">CGST (${(taxRate / 2).toFixed(2)}%)</span>
                           <span class="badge">SGST (${(taxRate / 2).toFixed(2)}%)</span>`;
            } else {
                taxHtml = `<span class="badge">IGST (${taxRate.toFixed(2)}%)</span>`;
            }

            $row.find('.taxes').html(taxHtml);
            $row.find('.itemTaxPrice').val(taxAmounts.total.toFixed(2));
            $row.find('.amount').html((totalPrice + taxAmounts.total).toFixed(2));
        });
    }

    function calculateTax(rate, price, isSameState) {
        const totalTax = (rate / 100) * price;
        if (taxType === 'vat') {
            return { total: totalTax, cgst: 0, sgst: 0, igst: 0 };
        }
        return isSameState
            ? { total: totalTax, cgst: totalTax / 2, sgst: totalTax / 2, igst: 0 }
            : { total: totalTax, cgst: 0, sgst: 0, igst: totalTax };
    }

    function getTotalItemTaxRate(taxes) {
        let cgst = 0, sgst = 0, igst = 0;
        if (taxes && Array.isArray(taxes)) {
            taxes.forEach(tax => {
                if (tax.name === 'CGST') cgst = parseFloat(tax.rate) || 0;
                if (tax.name === 'SGST') sgst = parseFloat(tax.rate) || 0;
                if (tax.name === 'IGST') igst = parseFloat(tax.rate) || 0;
            });
        }
        return (cgst + sgst > 0) ? cgst + sgst : igst;
    }

    function setTaxBadge($row, taxes) {
        let taxHtml = '';
        if (taxType === 'vat') {
            const vatRate = getTotalItemTaxRate(taxes);
            taxHtml = `<span class="badge">VAT (${vatRate.toFixed(2)}%)</span>`;
        } else {
            taxHtml = taxes && taxes.length
                ? taxes.map(t => `<span class="badge">${t.name} (${t.rate}%)</span>`).join('')
                : '<span class="badge">No Tax Data</span>';
        }
        $row.find('.taxes').html(taxHtml);
    }

    function calculateItemAmount($row) {
        const quantity = parseFloat($row.find('.quantity').val()) || 0;
        const price = parseFloat($row.find('.price').val()) || 0;
        const discount = parseFloat($row.find('.discount').val()) || 0;
        const taxRate = parseFloat($row.find('.itemTaxRate').val()) || 0;
        const totalPrice = quantity * price - discount;
        const taxAmount = (taxRate / 100) * totalPrice;
        $row.find('.itemTaxPrice').val(taxAmount.toFixed(2));
        $row.find('.amount').html((totalPrice + taxAmount).toFixed(2));
    }

    function updateTotals() {
        let totalPrice = 0, totalTax = 0, totalDiscount = 0, grandTotal = 0;
        $('.repeater tbody tr').each(function () {
            totalPrice += parseFloat($(this).find('.quantity').val() || 0) * parseFloat($(this).find('.price').val() || 0);
            totalTax += parseFloat($(this).find('.itemTaxPrice').val() || 0);
            totalDiscount += parseFloat($(this).find('.discount').val() || 0);
        });
        grandTotal = totalPrice + totalTax - totalDiscount;
        $('.subTotal').html(totalPrice.toFixed(2));
        $('.totalTax').html(totalTax.toFixed(2));
        $('.totalDiscount').html(totalDiscount.toFixed(2));
        $('.totalAmount').html(grandTotal.toFixed(2));
        console.log('Totals Updated:', { totalPrice, totalTax, totalDiscount, grandTotal });
    }

    function preserveItemSelection() {
        $('.item option').prop('hidden', false);
        $('.item :selected').each(function () {
            const id = $(this).val();
            if (id) {
                $('.item').not(this).find("option[value=" + id + "]").prop('hidden', true);
            }
        });
    }

    $(document).ready(function () {
        console.log('Document Ready - Initializing Tax Display');
        updateTaxDisplay();
        var customerId = '{{$customerId}}';
        if (customerId > 0) {
            $('#customer').val(customerId).change();
        }
    });
</script>

 
<script>
function validateDeliveryDistance() {
    const distanceInput = document.getElementById('delivery_distance');
    const message = document.getElementById('e_way_bill_message');
    const distance = parseFloat(distanceInput.value);

    if (isNaN(distance) || distance <= 4) {
        message.innerText = 'Delivery distance must be more than 4 KM to create an e-way bill.';
        message.style.display = 'block';
        distanceInput.focus();
        return false; // prevent form submission
    }

    message.innerText = '';
    message.style.display = 'none';
    return true;
}
</script>

@endpush

@push('css-page')
    <style>
        .taxes {
            display: block !important;
            overflow: visible !important;
            min-height: 20px;
            margin-bottom: 5px;
        }
        .tax-display {
            display: flex !important;
            flex-wrap: wrap;
            gap: 8px;
            align-items: center;
        }
        .taxes .badge {
            display: inline-block !important;
            white-space: normal !important;
            background-color: white;
            color: black;
            padding: 5px 10px;
            font-size: 0.85rem;
            border-radius: 5px;
        }
        @media (max-width: 768px) {
            .taxes { min-height: auto; margin-bottom: 10px; }
            .tax-display { flex-direction: column; gap: 10px; }
        }
    </style>
@endpush

@section('content')
    <div class="row">
        {{ Form::open(array('url' => 'ewaybill', 'class' => 'w-100 needs-validation', 'novalidate')) }}
        <div class="col-12">
            <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">
            <input type="hidden" name="company_state" value="{{ $company_state }}">
            <input type="hidden" name="billing_state" value="{{ $billing_state }}">
            
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
                            <div class="form-group" id="customer-box">
                                {{ Form::label('customer_id', __('Customer'), ['class' => 'form-label']) }}<x-required></x-required>
                                {{ Form::select('customer_id', $customers, $customerId, array('class' => 'form-control select', 'id' => 'customer', 'data-url' => route('ewaybill.customer'), 'required' => 'required')) }}
                                <div class="text-xs mt-1">
                                    {{ __('Create customer here.') }} <a href="{{ route('customer.index') }}"><b>{{ __('Create customer') }}</b></a>
                                </div>
                            </div>
                            <div id="customer_detail" class="d-none"></div>
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        {{ Form::label('issue_date', __('Issue Date'), ['class' => 'form-label']) }}<x-required></x-required>
                                        <div class="form-icon-user">
                                            {{ Form::date('issue_date', null, array('class' => 'form-control', 'required' => 'required')) }}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        {{ Form::label('due_date', __('Due Date'), ['class' => 'form-label']) }}<x-required></x-required>
                                        <div class="form-icon-user">
                                            {{ Form::date('due_date', null, array('class' => 'form-control', 'required' => 'required')) }}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        {{ Form::label('ewaybill_number', __('EWayBill Id'), ['class' => 'form-label']) }}
                                        <div class="form-icon-user">
                                            <input type="text" class="form-control" value="{{$ewaybill_number}}" readonly>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        {{ Form::label('category_id', __('Category'), ['class' => 'form-label']) }}<x-required></x-required>
                                        {{ Form::select('category_id', $category, null, array('class' => 'form-control select', 'required' => 'required')) }}
                                        <div class="text-xs mt-1">
                                            {{ __('Create category here.') }} <a href="{{ route('product-category.index') }}"><b>{{ __('Create category') }}</b></a>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        {{ Form::label('ref_number', __('Ref Number'), ['class' => 'form-label']) }}
                                        <div class="form-icon-user">
                                            <span><i class="ti ti-joint"></i></span>
                                            {{ Form::text('ref_number', '', array('class' => 'form-control', 'placeholder' => __('Enter Ref Number'))) }}
                                        </div>
                                    </div>
                                </div>
   <div class="col-md-6">
    <div class="form-group">
        {{ Form::label('delivery_distance', __('Delivery Distance (km)'), ['class' => 'form-label']) }}<x-required />
        <input type="number" step="0.1" name="delivery_distance" id="delivery_distance" class="form-control @error('delivery_distance') is-invalid @enderror" value="{{ old('delivery_distance') }}" required>

        {{-- Show error below the field --}}
        @error('delivery_distance')
            <span class="invalid-feedback d-block" role="alert">
                <strong>{{ $message }}</strong>
            </span>
        @enderror
    </div>
</div>


                     @if(!$customFields->isEmpty())
                                    @include('customFields.formBuilder')
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12">
            <h5 class="d-inline-block mb-4">{{__('Product & Services')}}</h5>
            <div class="card repeater">
                <div class="item-section py-2">
                    <div class="row justify-content-between align-items-center">
                        <div class="col-md-12 d-flex align-items-center justify-content-between justify-content-md-end">
                            <div class="all-button-box me-2">
                                <a href="#" data-repeater-create="" class="btn btn-primary d-flex align-items-center gap-1 justify-content-center">
                                    <i class="ti ti-plus"></i> {{__('Add item')}}
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body table-border-style mt-2">
                    <div class="table-responsive">
                        <table class="table mb-0 table-custom-style" data-repeater-list="items" id="sortable-table">
                            <thead>
                                <tr>
                                    <th>{{__('Items')}}<x-required></x-required></th>
                                    <th>{{__('Quantity')}}<x-required></x-required></th>
                                    <th>{{__('Price')}}<x-required></x-required></th>
                                    <th>{{__('Discount')}}<x-required></x-required></th>
                                    <th>{{__('Tax')}} (%)</th>
                                    <th class="text-end">{{__('Amount')}} <br><small class="text-danger font-weight-bold">{{__('after tax & discount')}}</small></th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody class="ui-sortable" data-repeater-item>
                                <tr>
                                    <td width="25%" class="form-group pt-0">
                                        {{ Form::select('item', $product_services, '', array('class' => 'form-control select2 item', 'data-url' => route('ewaybill.product'), 'required' => 'required')) }}
                                    </td>
                                    <td>
                                        <div class="form-group price-input input-group search-form">
                                            {{ Form::number('quantity', '', array('class' => 'form-control quantity', 'required' => 'required', 'placeholder' => __('Qty'))) }}
                                            <span class="unit input-group-text bg-transparent"></span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="form-group price-input input-group search-form">
                                            {{ Form::number('price', '', array('class' => 'form-control price', 'required' => 'required', 'placeholder' => __('Price'))) }}
                                            <span class="input-group-text bg-transparent">{{\Auth::user()->currencySymbol()}}</span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="form-group price-input input-group search-form">
                                            {{ Form::number('discount', '', array('class' => 'form-control discount', 'required' => 'required', 'placeholder' => __('Discount'))) }}
                                            <span class="input-group-text bg-transparent">{{\Auth::user()->currencySymbol()}}</span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="form-group">
                                            <div class="taxes"></div>
                                            {{ Form::hidden('tax', '', array('class' => 'form-control tax')) }}
                                            {{ Form::hidden('itemTaxPrice', '', array('class' => 'form-control itemTaxPrice')) }}
                                            {{ Form::hidden('itemTaxRate', '', array('class' => 'form-control itemTaxRate')) }}
                                        </div>
                                    </td>
                                    <td class="text-end amount">0.00</td>
                                    <td>
                                        <div class="action-btn me-2">
                                            <a href="#" class="ti ti-trash text-white btn btn-sm repeater-action-btn bg-danger ms-2" data-bs-toggle="tooltip" title="{{ __('Delete') }}" data-repeater-delete></a>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2">
                                        <div class="form-group">
                                            {{ Form::textarea('description', null, ['class' => 'form-control pro_description', 'rows' => '2', 'placeholder' => __('Description')]) }}
                                        </div>
                                    </td>
                                    <td colspan="5"></td>
                                </tr>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td> </td>
                                    <td> </td>
                                    <td> </td>
                                    <td></td>
                                    <td><strong>{{__('Sub Total')}} ({{\Auth::user()->currencySymbol()}})</strong></td>
                                    <td class="text-end subTotal">0.00</td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td> </td>
                                    <td> </td>
                                    <td> </td>
                                    <td></td>
                                    <td><strong>{{__('Discount')}} ({{\Auth::user()->currencySymbol()}})</strong></td>
                                    <td class="text-end totalDiscount">0.00</td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td> </td>
                                    <td> </td>
                                    <td> </td>
                                    <td></td>
                                    <td><strong>{{__('Tax')}} ({{\Auth::user()->currencySymbol()}})</strong></td>
                                    <td class="text-end totalTax">0.00</td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td> </td>
                                    <td> </td>
                                    <td> </td>
                                    <td> </td>
                                    <td class="blue-text"><strong>{{__('Total Amount')}} ({{\Auth::user()->currencySymbol()}})</strong></td>
                                    <td class="text-end totalAmount blue-text">0.00</td>
                                    <td></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <input type="button" value="{{__('Cancel')}}" onclick="location.href = '{{route('ewaybill.index')}}';" class="btn btn-secondary me-2">
            <input type="submit" value="{{__('Create')}}" class="btn btn-primary">
        </div>
        {{ Form::close() }}
    </div>
@endsection