<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PaySlip extends Model
{
protected $fillable = [
'employee_id',
'net_payble',
'basic_salary',
'salary_month',
'lop',
'days_in_month',
'working_days',
'status',
'allowance',
'commission',
'loan',
'saturation_deduction',
'other_payment',
'overtime',
'grace_days',
'created_by',
];

public static function employee($id)
{
return Employee::find($id);
}

public function employees()
{
return $this->hasOne('App\Models\Employee', 'id', 'employee_id');
}


public static function getGraceLeaveCount($employee_id, $month, $year)
{
$prevMonth = $month == 1 ? 12 : $month - 1;
$prevYear = $month == 1 ? $year - 1 : $year;
$prevSalaryMonth = Carbon::createFromDate($prevYear, $prevMonth, 1)->format('Y-m');

$prevLop = self::where('employee_id', $employee_id)
->where('salary_month', $prevSalaryMonth)
->sum('lop');

return match (true) {
$prevLop == 0 => 2,
$prevLop == 1 => 1,
default => 0,
};
}


}

