<?php

namespace App\Exports;

use App\Models\Branch;
use App\Models\Department;
use App\Models\Designation;
use App\Models\Employee;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class EmployeeExport implements FromCollection, WithHeadings
{
    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        $data = Employee::where('created_by', \Auth::user()->creatorId())->get();
        foreach ($data as $k => $employee) {
            $data[$k] = [
                'id' => $employee->id,
                'user_id' => $employee->user_id,
                'name' => $employee->name,
                'dob' => $employee->dob,
                'gender' => $employee->gender,
                'phone' => $employee->phone,
                'address' => $employee->address,
                'email' => $employee->email,
                'password' => $employee->password, 
                'employee_id' => $employee->employee_id,
                'biometric_emp_id' => $employee->biometric_emp_id,
                'branch' => !empty($employee->branch) ? $employee->branch->name : '-',
                'department' => !empty($employee->department) ? $employee->department->name : '-',
                'designation' => !empty($employee->designation) ? $employee->designation->name : '-',
                'company_doj' => $employee->company_doj,
                'documents' => $employee->documents,
                'account_holder_name' => $employee->account_holder_name,
                'account_number' => $employee->account_number,
                'bank_name' => $employee->bank_name,
                'bank_identifier_code' => $employee->bank_identifier_code,
                'branch_location' => $employee->branch_location,
                'tax_payer_id' => $employee->tax_payer_id,
                'account' => $employee->account,
                'salary_type' => $employee->salary_type,
                'salary' => Employee::employee_salary($employee->salary),
                'reporting_manager' => $employee->reporting_manager,
                'team_lead' => $employee->team_lead,
                'pf_number' => $employee->pf_number,
                'esi_number' => $employee->esi_number,
                'pran_number' => $employee->pran_number,
                'uan_number' => $employee->uan_number,
                'role' => $employee->role,
                'aadhar_number' => $employee->aadhar_number,
                'pan_number' => $employee->pan_number,
            ];
        }
        return $data;
    }

    public function headings(): array
    {
        return [
            "ID",
            "User ID",
            "Name",
            "Date of Birth",
            "Gender",
            "Phone Number",
            "Address",
            "Email ID",
            "Password",
            "Employee ID",
            "Biometric Employee ID",
            "Branch",
            "Department",
            "Designation",
            "Date of Join",
            "Documents",
            "Account Holder Name",
            "Account Number",
            "Bank Name",
            "Bank Identifier Code",
            "Branch Location",
            "Tax Payer ID",
             "Account",
            "Salary Type",
            "Salary",
            "Reporting Manager",
            "Team Lead",
            "PF Number",
            "ESI Number",
            "PRAN Number",
            "UAN Number",
            "Role",
            "Aadhar Number",
            "PAN Number",
            
        ];
    }
}